/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.animation.Bone;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.export.Savable;

public final class BoneDebugger {
    private static Sphere boneSphere = new Sphere("boneSphere", new Vector3f(), 6, 6, 0.125f);
    private static Box hardpointBox = new Box("hardpoint", new Vector3f(), 0.125f, 0.125f, 0.125f);
    private static Cylinder boneCylinder = new Cylinder("boneCylinder", 3, 8, 0.03f, 1.0f);
    private static boolean inited;
    private static Vector3f tempTrans;
    private static Vector3f tempScale;
    private static Quaternion tempRot;
    private static Quaternion tempQ;
    private static Vector3f tempA;
    private static Vector3f tempB;
    private static Vector3f tempC;
    private static Vector3f tempD;

    public static void drawBones(Spatial spatial, Renderer renderer) {
        BoneDebugger.drawBones(spatial, renderer, true);
    }

    public static void drawBones(Spatial spatial, Renderer renderer, boolean bl) {
        Savable savable;
        if (!inited) {
            savable = renderer.createTextureState();
            ((RenderState)savable).setEnabled(false);
            boneSphere.getBatch(0).setRenderState((RenderState)savable);
            hardpointBox.getBatch(0).setRenderState((RenderState)savable);
            boneCylinder.getBatch(0).setRenderState((RenderState)savable);
            ZBufferState zBufferState = renderer.createZBufferState();
            zBufferState.setEnabled(true);
            zBufferState.setWritable(true);
            zBufferState.setFunction(7);
            boneSphere.getBatch(0).setRenderState(zBufferState);
            hardpointBox.getBatch(0).setRenderState(zBufferState);
            boneCylinder.getBatch(0).setRenderState(zBufferState);
            boneSphere.updateRenderState();
            boneSphere.updateGeometricState(0.0f, false);
            hardpointBox.updateRenderState();
            hardpointBox.updateGeometricState(0.0f, false);
            boneCylinder.updateRenderState();
            boneCylinder.updateGeometricState(0.0f, false);
            boneSphere.lockMeshes();
            hardpointBox.lockMeshes();
            boneCylinder.lockMeshes();
            inited = true;
        }
        if (spatial instanceof Bone) {
            BoneDebugger.drawTheBones(null, (Bone)spatial, renderer);
        }
        if (spatial instanceof Node && bl) {
            savable = (Node)spatial;
            int n = ((Node)savable).getQuantity();
            for (int i = 0; i < n; ++i) {
                BoneDebugger.drawBones(((Node)savable).getChild(i), renderer, true);
            }
        }
    }

    private static void drawTheBones(Spatial spatial, Bone bone, Renderer renderer) {
        if (spatial == null) {
            tempTrans.set(0.0f, 0.0f, 0.0f);
            tempRot.set(0.0f, 0.0f, 0.0f, 1.0f);
            tempScale.set(1.0f, 1.0f, 1.0f);
        } else {
            tempTrans.set(spatial.getWorldTranslation());
            tempRot.set(spatial.getWorldRotation());
            tempScale.set(spatial.getWorldScale());
        }
        if (bone.isHardpoint()) {
            hardpointBox.getWorldTranslation().set(tempTrans).addLocal(tempRot.mult(bone.getWorldTranslation(), tempA));
            hardpointBox.getWorldRotation().set(tempRot).multLocal(bone.getWorldRotation());
            hardpointBox.getWorldScale().set(tempScale).multLocal(bone.getWorldScale());
            hardpointBox.getBatch(0).draw(renderer);
        } else {
            boneSphere.getWorldTranslation().set(tempTrans).addLocal(tempRot.mult(bone.getWorldTranslation(), tempA));
            boneSphere.getWorldRotation().set(tempRot).multLocal(bone.getWorldRotation());
            boneSphere.getWorldScale().set(tempScale).multLocal(bone.getWorldScale());
            boneSphere.getBatch(0).draw(renderer);
        }
        Vector3f vector3f = tempA;
        Vector3f vector3f2 = tempB;
        Vector3f vector3f3 = tempC;
        if (bone.getQuantity() > 0) {
            bone.localToWorld(Vector3f.ZERO, vector3f);
            float f = vector3f.getX();
            float f2 = vector3f.getY();
            float f3 = vector3f.getZ();
            int n = bone.getQuantity();
            for (int i = 0; i < n; ++i) {
                Spatial spatial2 = bone.getChild(i);
                if (!(spatial2 instanceof Bone)) continue;
                spatial2.localToWorld(Vector3f.ZERO, vector3f2);
                vector3f3.set(vector3f2).subtractLocal(vector3f);
                float f4 = vector3f.distance(vector3f2);
                boneCylinder.getWorldScale().set(1.0f, 1.0f, f4);
                boneCylinder.getWorldTranslation().set(vector3f3).multLocal(0.5f).addLocal(vector3f);
                tempD.set(boneCylinder.getWorldTranslation());
                boneCylinder.getWorldTranslation().set(tempTrans).addLocal(tempRot.mult(tempD, tempD));
                vector3f3.normalizeLocal();
                boneCylinder.getWorldRotation().set(bone.getWorldRotation()).lookAt(vector3f3, Vector3f.UNIT_Z);
                tempQ.set(boneCylinder.getWorldRotation());
                boneCylinder.getWorldRotation().set(tempRot).multLocal(tempQ);
                boneCylinder.getBatch(0).draw(renderer);
                BoneDebugger.drawTheBones(spatial, (Bone)spatial2, renderer);
                vector3f.set(f, f2, f3);
            }
        }
    }

    static {
        boneSphere.getBatch(0).setLightCombineMode(0);
        boneSphere.getBatch(0).setTextureCombineMode(0);
        boneSphere.getBatch(0).setSolidColor(ColorRGBA.red.clone());
        boneSphere.getBatch(0).setRenderQueueMode(1);
        hardpointBox.getBatch(0).setLightCombineMode(0);
        hardpointBox.getBatch(0).setTextureCombineMode(0);
        hardpointBox.getBatch(0).setSolidColor(ColorRGBA.green.clone());
        hardpointBox.getBatch(0).setRenderQueueMode(1);
        boneCylinder.getBatch(0).setLightCombineMode(0);
        boneCylinder.getBatch(0).setTextureCombineMode(0);
        boneCylinder.getBatch(0).setSolidColor(ColorRGBA.white.clone());
        boneCylinder.getBatch(0).setRenderQueueMode(1);
        inited = false;
        tempTrans = new Vector3f();
        tempScale = new Vector3f();
        tempRot = new Quaternion();
        tempQ = new Quaternion();
        tempA = new Vector3f();
        tempB = new Vector3f();
        tempC = new Vector3f();
        tempD = new Vector3f();
    }
}

