/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.system.PropertiesIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class PropertiesDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(PropertiesDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private PropertiesIO source = null;
    URL imageFile = null;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox rendererCombo = null;
    private JLabel icon = null;
    private boolean done = false;

    public PropertiesDialog(PropertiesIO propertiesIO, String string) {
        if (null == propertiesIO) {
            throw new JmeException("PropertyIO source cannot be null");
        }
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.source = propertiesIO;
        this.imageFile = uRL;
        this.init();
    }

    public PropertiesDialog(PropertiesIO propertiesIO, URL uRL) {
        if (null == propertiesIO) {
            throw new JmeException("PropertyIO source cannot be null");
        }
        this.source = propertiesIO;
        this.imageFile = uRL;
        this.init();
    }

    public boolean isDone() {
        return this.done;
    }

    public void setImage(String string) {
        URL uRL = null;
        try {
            uRL = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.setImage(uRL);
    }

    public void setImage(URL uRL) {
        this.icon.setIcon(new ImageIcon(uRL));
        this.pack();
        this.center();
    }

    private void showDialog() {
        this.setVisible(true);
        this.toFront();
    }

    private void center() {
        int n = (Toolkit.getDefaultToolkit().getScreenSize().width - this.getWidth()) / 2;
        int n2 = (Toolkit.getDefaultToolkit().getScreenSize().height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PropertiesDialog.this.dispose();
                System.exit(0);
            }
        });
        this.setTitle("Select Display Settings");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Ok");
        JButton jButton2 = new JButton("Cancel");
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        this.icon = new JLabel(new ImageIcon(this.imageFile));
        jPanel2.add((Component)this.icon, "North");
        this.displayResCombo = this.setUpResolutionChooser();
        this.colorDepthCombo = this.setUpColorDepthChooser();
        this.displayFreqCombo = this.setUpFreqChooser();
        jPanel3.add(this.displayResCombo);
        jPanel3.add(this.colorDepthCombo);
        jPanel3.add(this.displayFreqCombo);
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.getFullscreen());
        this.rendererCombo = this.setUpRendererChooser();
        jPanel3.add(this.fullscreenBox);
        jPanel3.add(this.rendererCombo);
        jPanel2.add((Component)jPanel3, "South");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertiesDialog.this.verifyAndSaveCurrentSelection()) {
                    PropertiesDialog.this.dispose();
                    PropertiesDialog.this.done = true;
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.dispose();
                System.exit(0);
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel4, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.center();
        this.showDialog();
    }

    private boolean verifyAndSaveCurrentSelection() {
        boolean bl;
        String string = (String)this.displayResCombo.getSelectedItem();
        int n = Integer.parseInt(string.substring(0, string.indexOf("x")));
        string = string.substring(string.indexOf("x") + 1);
        int n2 = Integer.parseInt(string);
        String string2 = (String)this.colorDepthCombo.getSelectedItem();
        int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(" ")));
        String string3 = (String)this.displayFreqCombo.getSelectedItem();
        int n4 = Integer.parseInt(string3.substring(0, string3.indexOf(" ")));
        boolean bl2 = this.fullscreenBox.isSelected();
        String string4 = (String)this.rendererCombo.getSelectedItem();
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem(string4);
        boolean bl3 = bl = displaySystem != null ? displaySystem.isValidDisplayMode(n, n2, n3, n4) : false;
        if (bl) {
            this.source.save(n, n2, n3, n4, bl2, string4);
        } else {
            JOptionPane.showMessageDialog(this, "The selected display mode is not valid!", "Invalid Mode", 0);
        }
        return bl;
    }

    private JComboBox setUpResolutionChooser() {
        String[] stringArray = new String[]{"640x480", "800x600", "1024x768", "1280x1024", "1600x1200"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getWidth() + "x" + this.source.getHeight());
        return jComboBox;
    }

    private JComboBox setUpColorDepthChooser() {
        String[] stringArray = new String[]{"16 bpp", "24 bpp", "32 bpp"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(String.valueOf(this.source.getDepth()) + " bpp");
        return jComboBox;
    }

    private JComboBox setUpFreqChooser() {
        String[] stringArray = new String[]{"0 Hz (Linux)", "60 Hz", "70 Hz", "75 Hz", "80 Hz", "85 Hz"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getFreq() + " Hz");
        return jComboBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] stringArray = DisplaySystem.getSystemProviderIdentifiers();
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem(this.source.getRenderer());
        return jComboBox;
    }
}

