/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.lod;

import com.jme.renderer.Renderer;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.lod.ClodCreator;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.lod.VETMesh;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ClodMesh
extends TriMesh {
    private static final long serialVersionUID = 1L;
    int currentRecord;
    int targetRecord;
    CollapseRecord[] records;

    public ClodMesh() {
    }

    public ClodMesh(String string) {
        super(string);
    }

    public ClodMesh(String string, TriMesh triMesh, CollapseRecord[] collapseRecordArray) {
        this(string, BufferUtils.clone(triMesh.getVertexBuffer(0)), BufferUtils.clone(triMesh.getNormalBuffer(0)), BufferUtils.clone(triMesh.getColorBuffer(0)), BufferUtils.clone(triMesh.getTextureBuffers(0)[0]), BufferUtils.clone(triMesh.getIndexBuffer(0)), collapseRecordArray);
    }

    public ClodMesh(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer, CollapseRecord[] collapseRecordArray) {
        super(string, floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer);
        this.create(collapseRecordArray);
    }

    public void create(CollapseRecord[] collapseRecordArray) {
        Object object;
        this.targetRecord = 0;
        this.currentRecord = 0;
        if (collapseRecordArray != null && collapseRecordArray.length > 0) {
            this.records = collapseRecordArray;
        } else {
            object = new ClodCreator(this.getVertexBuffer(0), this.getNormalBuffer(0), this.getColorBuffer(0), this.getTextureBuffers(0)[0], this.getIndexBuffer(0));
            this.records = ((ClodCreator)object).getRecords();
            ((VETMesh)object).removeAllTriangles();
            object = null;
        }
        object = this.getBatch(0);
        ((TriangleBatch)object).setTriangleQuantity(this.records[0].numbTriangles);
        ((GeomBatch)object).setVertexCount(this.records[0].numbVerts);
        this.updateModelBound();
    }

    private void selectLevelOfDetail(Renderer renderer) {
        int n;
        int n2;
        CollapseRecord collapseRecord;
        TriangleBatch triangleBatch = this.getBatch(0);
        int n3 = this.chooseTargetRecord(renderer);
        if (n3 == this.currentRecord) {
            return;
        }
        while (this.currentRecord < n3) {
            ++this.currentRecord;
            collapseRecord = this.records[this.currentRecord];
            for (n2 = 0; n2 < collapseRecord.numbIndices; ++n2) {
                n = collapseRecord.indices[n2];
                triangleBatch.getIndexBuffer().put(n, collapseRecord.vertToKeep);
            }
            triangleBatch.setVertexCount(collapseRecord.numbVerts);
            triangleBatch.setTriangleQuantity(collapseRecord.numbTriangles);
        }
        while (this.currentRecord > n3) {
            collapseRecord = this.records[this.currentRecord];
            for (n2 = 0; n2 < collapseRecord.numbIndices; ++n2) {
                n = collapseRecord.indices[n2];
                triangleBatch.getIndexBuffer().put(n, collapseRecord.vertToThrow);
            }
            --this.currentRecord;
            CollapseRecord collapseRecord2 = this.records[this.currentRecord];
            triangleBatch.setVertexCount(collapseRecord2.numbVerts);
            triangleBatch.setTriangleQuantity(collapseRecord2.numbTriangles);
        }
    }

    public void draw(Renderer renderer) {
        this.selectLevelOfDetail(renderer);
        super.draw(renderer);
    }

    public int getRecordQuantity() {
        return this.records.length;
    }

    public int chooseTargetRecord(Renderer renderer) {
        return this.targetRecord;
    }

    public int getTargetRecord() {
        return this.targetRecord;
    }

    public CollapseRecord[] getRecords() {
        return this.records;
    }

    public void setTargetRecord(int n) {
        this.targetRecord = n;
        if (this.targetRecord < 0) {
            this.targetRecord = 0;
        } else if (this.targetRecord > this.records.length - 1) {
            this.targetRecord = this.records.length - 1;
        }
    }

    public void setRecords(CollapseRecord[] collapseRecordArray) {
        this.records = collapseRecordArray;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.records, "records", null);
        outputCapsule.write(this.currentRecord, "currentRecord", 0);
        outputCapsule.write(this.targetRecord, "targetRecord", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        Savable[] savableArray = inputCapsule.readSavableArray("records", null);
        if (savableArray == null) {
            this.records = null;
        } else {
            this.records = new CollapseRecord[savableArray.length];
            for (int i = 0; i < savableArray.length; ++i) {
                this.records[i] = (CollapseRecord)savableArray[i];
            }
        }
        this.currentRecord = inputCapsule.readInt("currentRecord", 0);
        this.targetRecord = inputCapsule.readInt("targetRecord", 0);
        if (this.records == null) {
            this.create(this.records);
        }
    }
}

