/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.CollisionTree;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.CollisionResults;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.TriangleBatch;
import com.jme.system.JmeException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriMesh
extends Geometry
implements Serializable {
    private static final Logger logger = Logger.getLogger(TriMesh.class.getName());
    private static final long serialVersionUID = 2L;

    public TriMesh() {
    }

    public TriMesh(String string) {
        super(string);
    }

    public TriMesh(String string, FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer) {
        super(string);
        this.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4);
        if (null == intBuffer) {
            logger.severe("Indices may not be null.");
            throw new JmeException("Indices may not be null.");
        }
        this.getBatch(0).setIndexBuffer(intBuffer);
        this.getBatch(0).setTriangleQuantity(intBuffer.limit() / 3);
        logger.info("TriMesh created.");
    }

    @Override
    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        TriangleBatch triangleBatch = new TriangleBatch();
        triangleBatch.setParentGeom(this);
        this.batchList.add(triangleBatch);
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer) {
        this.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer, 0);
    }

    public void reconstruct(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer, int n) {
        super.reconstruct(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, n);
        if (null == intBuffer) {
            logger.severe("Indices may not be null.");
            throw new JmeException("Indices may not be null.");
        }
        this.getBatch(n).setIndexBuffer(intBuffer);
    }

    public IntBuffer getIndexBuffer(int n) {
        return this.getBatch(n).getIndexBuffer();
    }

    public void setIndexBuffer(int n, IntBuffer intBuffer) {
        this.getBatch(n).setIndexBuffer(intBuffer);
    }

    public void getTriangle(int n, int[] nArray) {
        this.getTriangle(0, n, nArray);
    }

    public void getTriangle(int n, int n2, int[] nArray) {
        TriangleBatch triangleBatch = this.getBatch(n);
        triangleBatch.getTriangle(n2, nArray);
    }

    public void getTriangle(int n, Vector3f[] vector3fArray) {
        this.getTriangle(n, vector3fArray, 0);
    }

    public void getTriangle(int n, Vector3f[] vector3fArray, int n2) {
        TriangleBatch triangleBatch = this.getBatch(n2);
        triangleBatch.getTriangle(n, vector3fArray);
    }

    @Override
    public int getTriangleCount() {
        int n = 0;
        for (int i = 0; i < this.getBatchCount(); ++i) {
            TriangleBatch triangleBatch = this.getBatch(i);
            if (triangleBatch == null || !triangleBatch.isEnabled()) continue;
            n += triangleBatch.getTriangleCount();
        }
        return n;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.getBatchCount() == 1) {
            TriangleBatch triangleBatch = this.getBatch(0);
            if (triangleBatch != null && triangleBatch.isEnabled()) {
                triangleBatch.setLastFrustumIntersection(this.frustrumIntersects);
                triangleBatch.draw(renderer);
            }
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            TriangleBatch triangleBatch = this.getBatch(i);
            if (triangleBatch == null || !triangleBatch.isEnabled()) continue;
            triangleBatch.onDraw(renderer);
        }
    }

    @Override
    public void clearBuffers() {
        super.clearBuffers();
        for (int i = 0; i < this.getBatchCount(); ++i) {
            this.getBatch(i).setIndexBuffer(null);
        }
    }

    @Override
    public boolean hasCollision(Spatial spatial, boolean bl) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return false;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    if (!this.hasCollision(node.getChild(i), bl)) continue;
                    return true;
                }
                return false;
            }
            if (!bl) {
                return true;
            }
            return this.hasTriangleCollision((TriMesh)spatial);
        }
        return false;
    }

    @Override
    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return;
        }
        if (this.getWorldBound().intersects(spatial.getWorldBound())) {
            if ((spatial.getType() & 1) != 0) {
                Node node = (Node)spatial;
                for (int i = 0; i < node.getQuantity(); ++i) {
                    this.findCollisions(node.getChild(i), collisionResults);
                }
            } else {
                collisionResults.addCollision(this, (Geometry)spatial);
            }
        }
    }

    public boolean hasTriangleCollision(TriMesh triMesh) {
        for (int i = 0; i < this.getBatchCount(); ++i) {
            TriangleBatch triangleBatch = this.getBatch(i);
            if (triangleBatch == null || !triangleBatch.isEnabled()) continue;
            for (int j = 0; j < triMesh.getBatchCount(); ++j) {
                TriangleBatch triangleBatch2 = triMesh.getBatch(j);
                if (triangleBatch2 == null || !triangleBatch2.isEnabled() || !this.hasTriangleCollision(triMesh, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTriangleCollision(TriMesh triMesh, int n, int n2) {
        CollisionTree collisionTree = CollisionTreeManager.getInstance().getCollisionTree(this.getBatch(n));
        CollisionTree collisionTree2 = CollisionTreeManager.getInstance().getCollisionTree(triMesh.getBatch(n2));
        if (collisionTree == null || collisionTree2 == null || !this.isCollidable || !triMesh.isCollidable()) {
            return false;
        }
        collisionTree.getBounds().transform(this.worldRotation, this.worldTranslation, this.worldScale, collisionTree.getWorldBounds());
        return collisionTree.intersect(collisionTree2);
    }

    public void findTriangleCollision(TriMesh triMesh, int n, int n2, ArrayList<Integer> arrayList, ArrayList<Integer> arrayList2) {
        CollisionTree collisionTree = CollisionTreeManager.getInstance().getCollisionTree(this.getBatch(n));
        CollisionTree collisionTree2 = CollisionTreeManager.getInstance().getCollisionTree(triMesh.getBatch(n2));
        if (collisionTree == null || collisionTree2 == null) {
            return;
        }
        collisionTree.getBounds().transform(this.worldRotation, this.worldTranslation, this.worldScale, collisionTree.getWorldBounds());
        collisionTree.intersect(collisionTree2, arrayList, arrayList2);
    }

    public void findTrianglePick(Ray ray, ArrayList<Integer> arrayList, int n) {
        TriangleBatch triangleBatch = this.getBatch(n);
        if (triangleBatch == null) {
            return;
        }
        triangleBatch.findTrianglePick(ray, arrayList);
    }

    public Vector3f[] getMeshAsTrianglesVertices(int n, Vector3f[] vector3fArray) {
        TriangleBatch triangleBatch = this.getBatch(n);
        if (triangleBatch != null) {
            return triangleBatch.getMeshAsTrianglesVertices(vector3fArray);
        }
        return vector3fArray;
    }

    public Triangle[] getMeshAsTriangles(int n, Triangle[] triangleArray) {
        TriangleBatch triangleBatch = this.getBatch(n);
        if (triangleBatch != null) {
            return triangleBatch.getMeshAsTriangles(triangleArray);
        }
        return triangleArray;
    }

    @Override
    public TriangleBatch getBatch(int n) {
        return (TriangleBatch)this.batchList.get(n);
    }
}

