/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.renderer.RenderContext;
import com.jme.renderer.Renderer;
import com.jme.scene.state.RenderState;

public class PassNodeState {
    protected boolean enabled = true;
    protected float zFactor;
    protected float zOffset;
    protected RenderState[] passStates = new RenderState[17];
    protected RenderState[] savedStates = new RenderState[17];

    public void applyPassNodeState(Renderer renderer, RenderContext renderContext) {
        this.applyPassStates(renderContext);
        renderer.setPolygonOffset(this.zFactor, this.zOffset);
    }

    public void resetPassNodeStates(Renderer renderer, RenderContext renderContext) {
        renderer.clearPolygonOffset();
        this.resetOldStates(renderContext);
    }

    public void setPassState(RenderState renderState) {
        this.passStates[renderState.getType()] = renderState;
    }

    public void clearPassState(int n) {
        this.passStates[n] = null;
    }

    public void clearPassStates() {
        for (int i = 0; i < this.passStates.length; ++i) {
            this.passStates[i] = null;
        }
    }

    protected void applyPassStates(RenderContext renderContext) {
        int n = 17;
        while (--n >= 0) {
            if (this.passStates[n] == null) continue;
            this.savedStates[n] = renderContext.enforcedStateList[n];
            renderContext.enforcedStateList[n] = this.passStates[n];
        }
    }

    protected void resetOldStates(RenderContext renderContext) {
        int n = 17;
        while (--n >= 0) {
            if (this.passStates[n] == null) continue;
            renderContext.enforcedStateList[n] = this.savedStates[n];
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public float getZFactor() {
        return this.zFactor;
    }

    public void setZFactor(float f) {
        this.zFactor = f;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(float f) {
        this.zOffset = f;
    }
}

