/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.bounding.BoundingVolume;
import com.jme.intersection.CollisionResults;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node
extends Spatial
implements Serializable,
Savable {
    private static final Logger logger = Logger.getLogger(Node.class.getName());
    private static final long serialVersionUID = 1L;
    protected ArrayList<Spatial> children;

    public Node() {
        logger.info("Node created.");
    }

    public Node(String string) {
        super(string);
        logger.info("Node created.");
    }

    public int getQuantity() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getTriangleCount() {
        int n = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                n += this.children.get(i).getTriangleCount();
            }
        }
        return n;
    }

    @Override
    public int getVertexCount() {
        int n = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                n += this.children.get(i).getVertexCount();
            }
        }
        return n;
    }

    public int attachChild(Spatial spatial) {
        if (spatial != null && spatial.getParent() != this) {
            if (spatial.getParent() != null) {
                spatial.getParent().detachChild(spatial);
            }
            spatial.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList(1);
            }
            this.children.add(spatial);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Child (" + spatial.getName() + ") attached to this" + " node (" + this.getName() + ")");
            }
        }
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int attachChildAt(Spatial spatial, int n) {
        if (spatial != null && spatial.getParent() != this) {
            if (spatial.getParent() != null) {
                spatial.getParent().detachChild(spatial);
            }
            spatial.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList(1);
            }
            this.children.add(n, spatial);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Child (" + spatial.getName() + ") attached to this" + " node (" + this.getName() + ")");
            }
        }
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int detachChild(Spatial spatial) {
        if (this.children == null) {
            return -1;
        }
        if (spatial == null) {
            return -1;
        }
        if (spatial.getParent() == this) {
            int n = this.children.indexOf(spatial);
            if (n != -1) {
                this.detachChildAt(n);
            }
            return n;
        }
        return -1;
    }

    public int detachChildNamed(String string) {
        if (this.children == null) {
            return -1;
        }
        if (string == null) {
            return -1;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (!string.equals(spatial.getName())) continue;
            this.detachChildAt(i);
            return i;
        }
        return -1;
    }

    public Spatial detachChildAt(int n) {
        if (this.children == null) {
            return null;
        }
        Spatial spatial = this.children.remove(n);
        if (spatial != null) {
            spatial.setParent(null);
            logger.info("Child removed.");
        }
        return spatial;
    }

    public void detachAllChildren() {
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                this.detachChildAt(i);
            }
            logger.info("All children removed.");
        }
    }

    public int getChildIndex(Spatial spatial) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(spatial);
    }

    public void swapChildren(int n, int n2) {
        Spatial spatial = this.children.get(n2);
        Spatial spatial2 = this.children.remove(n);
        this.children.add(n, spatial);
        this.children.remove(n2);
        this.children.add(n2, spatial2);
    }

    public Spatial getChild(int n) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(n);
    }

    public Spatial getChild(String string) {
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial;
            Spatial spatial2 = this.children.get(i);
            if (string.equals(spatial2.getName())) {
                return spatial2;
            }
            if (!(spatial2 instanceof Node) || (spatial = ((Node)spatial2).getChild(string)) == null) continue;
            return spatial;
        }
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    public boolean hasChild(Spatial spatial) {
        if (this.children == null) {
            return false;
        }
        if (this.children.contains(spatial)) {
            return true;
        }
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial2 = this.children.get(i);
            if ((spatial2.getType() & 1) == 0 || !((Node)spatial2).hasChild(spatial)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateWorldData(float f) {
        super.updateWorldData(f);
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial;
            try {
                spatial = this.children.get(i);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                break;
            }
            if (spatial == null) continue;
            spatial.updateGeometricState(f, false);
        }
    }

    @Override
    public void lockBounds() {
        super.lockBounds();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.lockBounds();
        }
    }

    @Override
    public void lockShadows() {
        super.lockShadows();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.lockShadows();
        }
    }

    @Override
    public void lockTransforms() {
        super.lockTransforms();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.lockTransforms();
        }
    }

    @Override
    public void lockMeshes(Renderer renderer) {
        super.lockMeshes(renderer);
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.lockMeshes(renderer);
        }
    }

    @Override
    public void unlockBounds() {
        super.unlockBounds();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.unlockBounds();
        }
    }

    @Override
    public void unlockShadows() {
        super.unlockShadows();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.unlockShadows();
        }
    }

    @Override
    public void unlockTransforms() {
        super.unlockTransforms();
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.unlockTransforms();
        }
    }

    @Override
    public void unlockMeshes(Renderer renderer) {
        super.unlockMeshes(renderer);
        int n = this.getQuantity();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.unlockMeshes(renderer);
        }
    }

    @Override
    public void draw(Renderer renderer) {
        if (this.children == null) {
            return;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            spatial.onDraw(renderer);
        }
    }

    @Override
    protected void applyRenderState(Stack[] stackArray) {
        if (this.children == null) {
            return;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.getChild(i);
            if (spatial == null) continue;
            spatial.updateRenderState(stackArray);
        }
    }

    @Override
    public void updateWorldBound() {
        if ((this.lockedMode & 1) != 0) {
            return;
        }
        if (this.children == null) {
            return;
        }
        BoundingVolume boundingVolume = null;
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            Spatial spatial = this.children.get(i);
            if (spatial == null) continue;
            if (boundingVolume != null) {
                boundingVolume.mergeLocal(spatial.getWorldBound());
                continue;
            }
            if (spatial.getWorldBound() == null) continue;
            boundingVolume = spatial.getWorldBound().clone(this.worldBound);
        }
        this.worldBound = boundingVolume;
    }

    @Override
    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
        if (this.getWorldBound() != null && this.isCollidable && spatial.isCollidable() && this.getWorldBound().intersects(spatial.getWorldBound())) {
            for (int i = 0; i < this.getQuantity(); ++i) {
                this.getChild(i).findCollisions(spatial, collisionResults);
            }
        }
    }

    @Override
    public boolean hasCollision(Spatial spatial, boolean bl) {
        if (this.getWorldBound() != null && this.isCollidable && spatial.isCollidable() && this.getWorldBound().intersects(spatial.getWorldBound())) {
            if (this.children == null && !bl) {
                return true;
            }
            for (int i = 0; i < this.getQuantity(); ++i) {
                if (!this.getChild(i).hasCollision(spatial, bl)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void findPick(Ray ray, PickResults pickResults) {
        if (this.children == null) {
            return;
        }
        if (this.getWorldBound() != null && this.isCollidable && this.getWorldBound().intersects(ray)) {
            for (int i = 0; i < this.getQuantity(); ++i) {
                this.children.get(i).findPick(ray, pickResults);
            }
        }
    }

    public ArrayList<Spatial> getChildren() {
        return this.children;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = this.children.get(i);
                spatial.parent = this;
            }
        }
    }

    public void batchChange(Geometry geometry, int n, int n2) {
        if (this.parent != null) {
            this.parent.batchChange(geometry, n, n2);
        }
    }

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        jMEExporter.getCapsule(this).writeSavableArrayList(this.children, "children", null);
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        this.children = jMEImporter.getCapsule(this).readSavableArrayList("children", null);
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                Spatial spatial = this.children.get(i);
                spatial.parent = this;
            }
        }
    }

    @Override
    public void setModelBound(BoundingVolume boundingVolume) {
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                this.children.get(i).setModelBound(boundingVolume != null ? boundingVolume.clone(null) : null);
            }
        }
    }

    @Override
    public void updateModelBound() {
        if (this.children != null) {
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                this.children.get(i).updateModelBound();
            }
        }
    }
}

