/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.renderer.ColorRGBA;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public abstract class Light
implements Serializable,
Savable {
    public static final int LT_DIRECTIONAL = 0;
    public static final int LT_POINT = 1;
    public static final int LT_SPOT = 2;
    private ColorRGBA ambient = new ColorRGBA(0.4f, 0.4f, 0.4f, 1.0f);
    private ColorRGBA diffuse = new ColorRGBA();
    private ColorRGBA specular = new ColorRGBA();
    private boolean attenuate;
    private float constant = 1.0f;
    private float linear;
    private float quadratic;
    private int lightMask = 0;
    private int backLightMask = 0;
    private boolean enabled;
    protected boolean shadowCaster;

    public abstract int getType();

    public float getConstant() {
        return this.constant;
    }

    public void setConstant(float f) {
        this.constant = f;
    }

    public float getLinear() {
        return this.linear;
    }

    public void setLinear(float f) {
        this.linear = f;
    }

    public float getQuadratic() {
        return this.quadratic;
    }

    public void setQuadratic(float f) {
        this.quadratic = f;
    }

    public boolean isAttenuate() {
        return this.attenuate;
    }

    public void setAttenuate(boolean bl) {
        this.attenuate = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public ColorRGBA getSpecular() {
        return this.specular;
    }

    public void setSpecular(ColorRGBA colorRGBA) {
        this.specular = colorRGBA;
    }

    public ColorRGBA getDiffuse() {
        return this.diffuse;
    }

    public void setDiffuse(ColorRGBA colorRGBA) {
        this.diffuse = colorRGBA;
    }

    public ColorRGBA getAmbient() {
        return this.ambient;
    }

    public void setAmbient(ColorRGBA colorRGBA) {
        this.ambient = colorRGBA;
    }

    public int getLightMask() {
        return this.lightMask;
    }

    public void setLightMask(int n) {
        this.lightMask = n;
    }

    public void pushLightMask() {
        this.backLightMask = this.lightMask;
    }

    public void popLightMask() {
        this.lightMask = this.backLightMask;
    }

    public boolean isShadowCaster() {
        return this.shadowCaster;
    }

    public void setShadowCaster(boolean bl) {
        this.shadowCaster = bl;
    }

    public void copyFrom(Light light) {
        this.ambient = new ColorRGBA(light.ambient);
        this.attenuate = light.attenuate;
        this.constant = light.constant;
        this.diffuse = new ColorRGBA(light.diffuse);
        this.enabled = light.enabled;
        this.linear = light.linear;
        this.quadratic = light.quadratic;
        this.shadowCaster = light.shadowCaster;
        this.specular = new ColorRGBA(light.specular);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.ambient, "ambient", ColorRGBA.black);
        outputCapsule.write(this.diffuse, "diffuse", ColorRGBA.black);
        outputCapsule.write(this.specular, "specular", ColorRGBA.black);
        outputCapsule.write(this.attenuate, "attenuate", false);
        outputCapsule.write(this.constant, "constant", 1.0f);
        outputCapsule.write(this.linear, "linear", 0.0f);
        outputCapsule.write(this.quadratic, "quadratic", 0.0f);
        outputCapsule.write(this.lightMask, "lightMask", 0);
        outputCapsule.write(this.backLightMask, "backLightMask", 0);
        outputCapsule.write(this.enabled, "enabled", false);
        outputCapsule.write(this.shadowCaster, "shadowCaster", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.ambient = (ColorRGBA)inputCapsule.readSavable("ambient", ColorRGBA.black.clone());
        this.diffuse = (ColorRGBA)inputCapsule.readSavable("diffuse", ColorRGBA.black.clone());
        this.specular = (ColorRGBA)inputCapsule.readSavable("specular", ColorRGBA.black.clone());
        this.attenuate = inputCapsule.readBoolean("attenuate", false);
        this.constant = inputCapsule.readFloat("constant", 1.0f);
        this.linear = inputCapsule.readFloat("linear", 0.0f);
        this.quadratic = inputCapsule.readFloat("quadratic", 0.0f);
        this.lightMask = inputCapsule.readInt("lightMask", 0);
        this.backLightMask = inputCapsule.readInt("backLightMask", 0);
        this.enabled = inputCapsule.readBoolean("enabled", false);
        this.shadowCaster = inputCapsule.readBoolean("shadowCaster", false);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

