/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls.controller;

import com.jme.input.controls.GameControl;
import com.jme.input.controls.controller.camera.CameraPerspective;
import com.jme.renderer.Camera;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import java.util.ArrayList;
import java.util.List;

public class CameraController
extends Controller {
    private Spatial spatial;
    private Camera camera;
    private GameControl control;
    private List<CameraPerspective> perspectives;
    private int currentPerspective;
    private boolean pressed;
    private boolean firstUpdate;

    public CameraController(Spatial spatial, Camera camera, GameControl gameControl) {
        this.spatial = spatial;
        this.camera = camera;
        this.control = gameControl;
        this.perspectives = new ArrayList<CameraPerspective>();
        this.firstUpdate = true;
    }

    public void addPerspective(CameraPerspective cameraPerspective) {
        this.perspectives.add(cameraPerspective);
    }

    public void nextPerspective() {
        this.perspectives.get(this.currentPerspective).setActive(this.camera, this.spatial, false);
        ++this.currentPerspective;
        if (this.currentPerspective >= this.perspectives.size()) {
            this.currentPerspective = 0;
        }
        this.perspectives.get(this.currentPerspective).setActive(this.camera, this.spatial, true);
    }

    public void update(float f) {
        if (this.firstUpdate) {
            this.perspectives.get(this.currentPerspective).setActive(this.camera, this.spatial, true);
            this.firstUpdate = false;
        }
        if (this.pressed) {
            if (this.control.getValue() == 0.0f) {
                this.pressed = false;
            }
        } else if (this.control.getValue() > 0.0f) {
            this.pressed = true;
            this.nextPerspective();
        }
        if (this.perspectives.size() > this.currentPerspective) {
            this.perspectives.get(this.currentPerspective).update(this.camera, this.spatial, f);
        }
    }
}

