/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.controls;

import com.jme.input.controls.Binding;
import com.jme.input.controls.GameControlManager;
import com.jme.input.controls.binding.JoystickAxisBinding;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameControl
implements Serializable {
    private static final long serialVersionUID = 6266549836236136920L;
    private String name;
    private GameControlManager manager;
    private List<Binding> bindings;
    private boolean enabled;

    protected GameControl(String string, GameControlManager gameControlManager) {
        this.name = string;
        this.manager = gameControlManager;
        this.bindings = new LinkedList<Binding>();
        this.enabled = true;
    }

    public List<Binding> getBindings() {
        return this.bindings;
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public void addBinding(Binding binding) {
        if (binding == null) {
            return;
        }
        this.bindings.add(binding);
    }

    public void removeBinding(Binding binding) {
        for (Binding binding2 : this.bindings) {
            if (!binding2.toString().equals(binding.toString())) continue;
            this.bindings.remove(binding2);
            return;
        }
    }

    public void replace(Binding binding, Binding binding2) {
        if (binding != null) {
            this.removeBinding(binding);
        }
        this.addBinding(binding2);
    }

    public boolean containsBinding(Binding binding) {
        for (Binding binding2 : this.bindings) {
            if (!binding2.toString().equals(binding.toString())) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public float getValue() {
        float f = 0.0f;
        if (!this.isEnabled()) {
            return f;
        }
        for (Binding binding : this.bindings) {
            if (!(binding.getValue() > f)) continue;
            f = binding.getValue();
        }
        return f;
    }

    public boolean hasTrueAxis() {
        for (Binding binding : this.bindings) {
            if (!(binding instanceof JoystickAxisBinding)) continue;
            return true;
        }
        return false;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        if (this.manager.isEnabled()) {
            return this.enabled;
        }
        return false;
    }
}

