/*
 * Decompiled with CFR 0.152.
 */
package com.jme.bounding;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.intersection.IntersectionRecord;
import com.jme.math.FastMath;
import com.jme.math.Plane;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Triangle;
import com.jme.math.Vector3f;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoundingSphere
extends BoundingVolume {
    private static final Logger logger = Logger.getLogger(BoundingSphere.class.getName());
    public float radius;
    private static final long serialVersionUID = 2L;
    private static final float radiusEpsilon = 1.00001f;
    private static final FloatBuffer _mergeBuf = BufferUtils.createVector3Buffer(8);
    private static final Vector3f[] verts = new Vector3f[3];
    private static Vector3f tempA = new Vector3f();
    private static Vector3f tempB = new Vector3f();
    private static Vector3f tempC = new Vector3f();
    private static Vector3f tempD = new Vector3f();
    private Vector3f tmpRadVect = new Vector3f();

    public BoundingSphere() {
    }

    public BoundingSphere(float f, Vector3f vector3f) {
        this.center.set(vector3f);
        this.radius = f;
    }

    public int getType() {
        return 0;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void computeFromPoints(FloatBuffer floatBuffer) {
        this.calcWelzl(floatBuffer);
    }

    public void computeFromBatches(ArrayList arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        BoundingSphere boundingSphere = new BoundingSphere();
        boundingSphere.calcWelzl(((GeomBatch)arrayList.get(0)).getVertexBuffer());
        for (int i = 1; i < arrayList.size(); ++i) {
            BoundingSphere boundingSphere2 = new BoundingSphere();
            boundingSphere2.calcWelzl(((GeomBatch)arrayList.get(i)).getVertexBuffer());
            boundingSphere.mergeLocal(boundingSphere2);
        }
        this.center = boundingSphere.getCenter();
        this.radius = boundingSphere.getRadius();
    }

    public void computeFromTris(Triangle[] triangleArray, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f[] vector3fArray = new Vector3f[(n2 - n) * 3];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            vector3fArray[n3++] = triangleArray[i].get(0);
            vector3fArray[n3++] = triangleArray[i].get(1);
            vector3fArray[n3++] = triangleArray[i].get(2);
        }
        this.averagePoints(vector3fArray);
    }

    public void computeFromTris(int[] nArray, TriangleBatch triangleBatch, int n, int n2) {
        if (n2 - n <= 0) {
            return;
        }
        Vector3f[] vector3fArray = new Vector3f[(n2 - n) * 3];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            triangleBatch.getTriangle(nArray[i], verts);
            vector3fArray[n3++] = new Vector3f(verts[0]);
            vector3fArray[n3++] = new Vector3f(verts[1]);
            vector3fArray[n3++] = new Vector3f(verts[2]);
        }
        this.averagePoints(vector3fArray);
    }

    public void calcWelzl(FloatBuffer floatBuffer) {
        if (this.center == null) {
            this.center = new Vector3f();
        }
        FloatBuffer floatBuffer2 = BufferUtils.createFloatBuffer(floatBuffer.limit());
        floatBuffer.rewind();
        floatBuffer2.put(floatBuffer);
        floatBuffer2.flip();
        this.recurseMini(floatBuffer2, floatBuffer2.limit() / 3, 0, 0);
    }

    private void recurseMini(FloatBuffer floatBuffer, int n, int n2, int n3) {
        switch (n2) {
            case 0: {
                this.radius = 0.0f;
                this.center.set(0.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                this.radius = -1.001358E-5f;
                BufferUtils.populateFromBuffer(this.center, floatBuffer, n3 - 1);
                break;
            }
            case 2: {
                BufferUtils.populateFromBuffer(tempA, floatBuffer, n3 - 1);
                BufferUtils.populateFromBuffer(tempB, floatBuffer, n3 - 2);
                this.setSphere(tempA, tempB);
                break;
            }
            case 3: {
                BufferUtils.populateFromBuffer(tempA, floatBuffer, n3 - 1);
                BufferUtils.populateFromBuffer(tempB, floatBuffer, n3 - 2);
                BufferUtils.populateFromBuffer(tempC, floatBuffer, n3 - 3);
                this.setSphere(tempA, tempB, tempC);
                break;
            }
            case 4: {
                BufferUtils.populateFromBuffer(tempA, floatBuffer, n3 - 1);
                BufferUtils.populateFromBuffer(tempB, floatBuffer, n3 - 2);
                BufferUtils.populateFromBuffer(tempC, floatBuffer, n3 - 3);
                BufferUtils.populateFromBuffer(tempD, floatBuffer, n3 - 4);
                this.setSphere(tempA, tempB, tempC, tempD);
                return;
            }
        }
        for (int i = 0; i < n; ++i) {
            BufferUtils.populateFromBuffer(tempA, floatBuffer, i + n3);
            if (!(tempA.distanceSquared(this.center) - this.radius * this.radius > 1.001358E-5f)) continue;
            for (int j = i; j > 0; --j) {
                BufferUtils.populateFromBuffer(tempB, floatBuffer, j + n3);
                BufferUtils.populateFromBuffer(tempC, floatBuffer, j - 1 + n3);
                BufferUtils.setInBuffer(tempC, floatBuffer, j + n3);
                BufferUtils.setInBuffer(tempB, floatBuffer, j - 1 + n3);
            }
            this.recurseMini(floatBuffer, i, n2 + 1, n3 + 1);
        }
    }

    private void setSphere(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        Vector3f vector3f5 = vector3f2.subtract(vector3f);
        Vector3f vector3f6 = vector3f3.subtract(vector3f);
        Vector3f vector3f7 = vector3f4.subtract(vector3f);
        float f = 2.0f * (vector3f5.x * (vector3f6.y * vector3f7.z - vector3f7.y * vector3f6.z) - vector3f6.x * (vector3f5.y * vector3f7.z - vector3f7.y * vector3f5.z) + vector3f7.x * (vector3f5.y * vector3f6.z - vector3f6.y * vector3f5.z));
        if (f == 0.0f) {
            this.center.set(0.0f, 0.0f, 0.0f);
            this.radius = 0.0f;
        } else {
            Vector3f vector3f8 = vector3f5.cross(vector3f6).multLocal(vector3f7.lengthSquared()).addLocal(vector3f7.cross(vector3f5).multLocal(vector3f6.lengthSquared())).addLocal(vector3f6.cross(vector3f7).multLocal(vector3f5.lengthSquared())).divideLocal(f);
            this.radius = vector3f8.length() * 1.00001f;
            vector3f.add(vector3f8, this.center);
        }
    }

    private void setSphere(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4;
        Vector3f vector3f5 = vector3f2.subtract(vector3f);
        Vector3f vector3f6 = vector3f5.cross(vector3f4 = vector3f3.subtract(vector3f));
        float f = 2.0f * vector3f6.dot(vector3f6);
        if (f == 0.0f) {
            this.center.set(0.0f, 0.0f, 0.0f);
            this.radius = 0.0f;
        } else {
            Vector3f vector3f7 = vector3f6.cross(vector3f5).multLocal(vector3f4.lengthSquared()).addLocal(vector3f4.cross(vector3f6).multLocal(vector3f5.lengthSquared())).divideLocal(f);
            this.radius = vector3f7.length() * 1.00001f;
            vector3f.add(vector3f7, this.center);
        }
    }

    private void setSphere(Vector3f vector3f, Vector3f vector3f2) {
        this.radius = FastMath.sqrt(((vector3f2.x - vector3f.x) * (vector3f2.x - vector3f.x) + (vector3f2.y - vector3f.y) * (vector3f2.y - vector3f.y) + (vector3f2.z - vector3f.z) * (vector3f2.z - vector3f.z)) / 4.0f) + 1.00001f - 1.0f;
        this.center.interpolate(vector3f, vector3f2, 0.5f);
    }

    public void averagePoints(Vector3f[] vector3fArray) {
        logger.info("Bounding Sphere calculated using average points.");
        this.center = vector3fArray[0];
        for (int i = 1; i < vector3fArray.length; ++i) {
            this.center.addLocal(vector3fArray[i]);
        }
        float f = 1.0f / (float)vector3fArray.length;
        this.center.multLocal(f);
        float f2 = 0.0f;
        for (int i = 0; i < vector3fArray.length; ++i) {
            Vector3f vector3f = vector3fArray[i].subtract(this.center);
            float f3 = vector3f.lengthSquared();
            if (!(f3 > f2)) continue;
            f2 = f3;
        }
        this.radius = (float)Math.sqrt(f2) + 1.00001f - 1.0f;
    }

    public BoundingVolume transform(Quaternion quaternion, Vector3f vector3f, Vector3f vector3f2, BoundingVolume boundingVolume) {
        BoundingSphere boundingSphere = boundingVolume == null || boundingVolume.getType() != 0 ? new BoundingSphere(1.0f, new Vector3f(0.0f, 0.0f, 0.0f)) : (BoundingSphere)boundingVolume;
        this.center.mult(vector3f2, boundingSphere.center);
        quaternion.mult(boundingSphere.center, boundingSphere.center);
        boundingSphere.center.addLocal(vector3f);
        boundingSphere.radius = FastMath.abs(this.getMaxAxis(vector3f2) * this.radius) + 1.00001f - 1.0f;
        return boundingSphere;
    }

    private float getMaxAxis(Vector3f vector3f) {
        float f = FastMath.abs(vector3f.x);
        float f2 = FastMath.abs(vector3f.y);
        float f3 = FastMath.abs(vector3f.z);
        if (f >= f2) {
            if (f >= f3) {
                return f;
            }
            return f3;
        }
        if (f2 >= f3) {
            return f2;
        }
        return f3;
    }

    public int whichSide(Plane plane) {
        float f = plane.pseudoDistance(this.center);
        if (f <= -this.radius) {
            return 2;
        }
        if (f >= this.radius) {
            return 1;
        }
        return 0;
    }

    public BoundingVolume merge(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 0: {
                BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
                float f = boundingSphere.getRadius();
                Vector3f vector3f = boundingSphere.getCenter();
                BoundingSphere boundingSphere2 = new BoundingSphere();
                return this.merge(f, vector3f, boundingSphere2);
            }
            case 3: {
                BoundingCapsule boundingCapsule = (BoundingCapsule)boundingVolume;
                float f = boundingCapsule.getRadius() + boundingCapsule.getLineSegment().getExtent();
                Vector3f vector3f = boundingCapsule.getCenter();
                BoundingSphere boundingSphere = new BoundingSphere();
                return this.merge(f, vector3f, boundingSphere);
            }
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                Vector3f vector3f = new Vector3f(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
                Vector3f vector3f2 = boundingBox.center;
                BoundingSphere boundingSphere = new BoundingSphere();
                return this.merge(vector3f.length(), vector3f2, boundingSphere);
            }
            case 2: {
                OrientedBoundingBox orientedBoundingBox = (OrientedBoundingBox)boundingVolume;
                BoundingSphere boundingSphere = (BoundingSphere)this.clone(null);
                return boundingSphere.mergeOBB(orientedBoundingBox);
            }
        }
        return null;
    }

    public BoundingVolume mergeLocal(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return this;
        }
        switch (boundingVolume.getType()) {
            case 0: {
                BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
                float f = boundingSphere.getRadius();
                Vector3f vector3f = boundingSphere.getCenter();
                return this.merge(f, vector3f, this);
            }
            case 1: {
                BoundingBox boundingBox = (BoundingBox)boundingVolume;
                Vector3f vector3f = this.tmpRadVect;
                vector3f.set(boundingBox.xExtent, boundingBox.yExtent, boundingBox.zExtent);
                Vector3f vector3f2 = boundingBox.center;
                return this.merge(vector3f.length(), vector3f2, this);
            }
            case 2: {
                return this.mergeOBB((OrientedBoundingBox)boundingVolume);
            }
            case 3: {
                BoundingCapsule boundingCapsule = (BoundingCapsule)boundingVolume;
                return this.merge(boundingCapsule.getRadius() + boundingCapsule.getLineSegment().getExtent(), boundingCapsule.getCenter(), this);
            }
        }
        return null;
    }

    private BoundingSphere mergeOBB(OrientedBoundingBox orientedBoundingBox) {
        if (!orientedBoundingBox.correctCorners) {
            orientedBoundingBox.computeCorners();
        }
        _mergeBuf.rewind();
        for (int i = 0; i < 8; ++i) {
            _mergeBuf.put(orientedBoundingBox.vectorStore[i].x);
            _mergeBuf.put(orientedBoundingBox.vectorStore[i].y);
            _mergeBuf.put(orientedBoundingBox.vectorStore[i].z);
        }
        float f = this.radius;
        Vector3f vector3f = _compVect2.set(this.center);
        this.computeFromPoints(_mergeBuf);
        Vector3f vector3f2 = _compVect1.set(this.center);
        float f2 = this.radius;
        this.center.set(vector3f);
        this.radius = f;
        this.merge(f2, vector3f2, this);
        return this;
    }

    private BoundingVolume merge(float f, Vector3f vector3f, BoundingSphere boundingSphere) {
        float f2 = f - this.radius;
        float f3 = f2 * f2;
        Vector3f vector3f2 = vector3f.subtract(this.center, _compVect1);
        float f4 = vector3f2.lengthSquared();
        if (f3 >= f4) {
            if (f2 <= 0.0f) {
                return this;
            }
            Vector3f vector3f3 = boundingSphere.getCenter();
            if (vector3f3 == null) {
                vector3f3 = new Vector3f();
                boundingSphere.setCenter(vector3f3);
            }
            vector3f3.set(vector3f);
            boundingSphere.setRadius(f);
            return boundingSphere;
        }
        float f5 = (float)Math.sqrt(f4);
        Vector3f vector3f4 = boundingSphere.getCenter();
        if (vector3f4 == null) {
            vector3f4 = new Vector3f();
            boundingSphere.setCenter(vector3f4);
        }
        if (f5 > 1.00001f) {
            float f6 = (f5 + f2) / (2.0f * f5);
            vector3f4.set(this.center.addLocal(vector3f2.multLocal(f6)));
        } else {
            vector3f4.set(this.center);
        }
        boundingSphere.setRadius(0.5f * (f5 + this.radius + f));
        return boundingSphere;
    }

    public BoundingVolume clone(BoundingVolume boundingVolume) {
        if (boundingVolume != null && boundingVolume.getType() == 0) {
            BoundingSphere boundingSphere = (BoundingSphere)boundingVolume;
            if (null == boundingSphere.center) {
                boundingSphere.center = new Vector3f();
            }
            boundingSphere.center.set(this.center);
            boundingSphere.radius = this.radius;
            boundingSphere.checkPlane = this.checkPlane;
            return boundingSphere;
        }
        return new BoundingSphere(this.radius, this.center != null ? this.center.clone() : null);
    }

    public String toString() {
        return "com.jme.scene.BoundingSphere [Radius: " + this.radius + " Center: " + this.center + "]";
    }

    public boolean intersects(BoundingVolume boundingVolume) {
        if (boundingVolume == null) {
            return false;
        }
        return boundingVolume.intersectsSphere(this);
    }

    public boolean intersectsSphere(BoundingSphere boundingSphere) {
        Vector3f vector3f = this.getCenter().subtract(boundingSphere.getCenter(), _compVect1);
        float f = this.getRadius() + boundingSphere.getRadius();
        return vector3f.dot(vector3f) <= f * f;
    }

    public boolean intersectsBoundingBox(BoundingBox boundingBox) {
        return FastMath.abs(boundingBox.center.x - this.getCenter().x) < this.getRadius() + boundingBox.xExtent && FastMath.abs(boundingBox.center.y - this.getCenter().y) < this.getRadius() + boundingBox.yExtent && FastMath.abs(boundingBox.center.z - this.getCenter().z) < this.getRadius() + boundingBox.zExtent;
    }

    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox orientedBoundingBox) {
        return orientedBoundingBox.intersectsSphere(this);
    }

    public boolean intersectsCapsule(BoundingCapsule boundingCapsule) {
        return boundingCapsule.intersectsSphere(this);
    }

    public boolean intersects(Ray ray) {
        Vector3f vector3f = _compVect1.set(ray.getOrigin()).subtractLocal(this.getCenter());
        float f = this.getRadius() * this.getRadius();
        float f2 = vector3f.dot(vector3f) - f;
        if ((double)f2 <= 0.0) {
            return true;
        }
        float f3 = ray.getDirection().dot(vector3f);
        if ((double)f3 >= 0.0) {
            return false;
        }
        return f3 * f3 >= f2;
    }

    public IntersectionRecord intersectsWhere(Ray ray) {
        Vector3f vector3f = _compVect1.set(ray.getOrigin()).subtractLocal(this.getCenter());
        float f = vector3f.dot(vector3f) - this.getRadius() * this.getRadius();
        if ((double)f <= 0.0) {
            float f2 = ray.direction.dot(vector3f);
            float f3 = f2 * f2 - f;
            float f4 = FastMath.sqrt(f3);
            float[] fArray = new float[]{f4 - f2};
            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray[0]).addLocal(ray.origin)};
            IntersectionRecord intersectionRecord = new IntersectionRecord(fArray, vector3fArray);
            return intersectionRecord;
        }
        float f5 = ray.direction.dot(vector3f);
        if ((double)f5 >= 0.0) {
            return new IntersectionRecord();
        }
        float f6 = f5 * f5 - f;
        if ((double)f6 < 0.0) {
            return new IntersectionRecord();
        }
        if (f6 >= 1.0E-4f) {
            float f7 = FastMath.sqrt(f6);
            float[] fArray = new float[]{-f5 - f7, -f5 + f7};
            Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray[0]).addLocal(ray.origin), new Vector3f(ray.direction).multLocal(fArray[1]).addLocal(ray.origin)};
            IntersectionRecord intersectionRecord = new IntersectionRecord(fArray, vector3fArray);
            return intersectionRecord;
        }
        float[] fArray = new float[]{-f5};
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(ray.direction).multLocal(fArray[0]).addLocal(ray.origin)};
        IntersectionRecord intersectionRecord = new IntersectionRecord(fArray, vector3fArray);
        return intersectionRecord;
    }

    public boolean contains(Vector3f vector3f) {
        return this.getCenter().distanceSquared(vector3f) < this.getRadius() * this.getRadius();
    }

    public float distanceToEdge(Vector3f vector3f) {
        return this.center.distance(vector3f) - this.radius;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        try {
            jMEExporter.getCapsule(this).write(this.radius, "radius", 0.0f);
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "write(JMEExporter)", "Exception", iOException);
        }
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        try {
            this.radius = jMEImporter.getCapsule(this).readFloat("radius", 0.0f);
        }
        catch (IOException iOException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "read(JMEImporter)", "Exception", iOException);
        }
    }

    public float getVolume() {
        return 4.1887903f * this.radius * this.radius * this.radius;
    }
}

