/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;

public class BinaryToXML {
    private DataInputStream myIn;
    private Writer XMLFile;
    private short tabCount;
    private StringBuffer currentLine;
    private static final boolean DEBUG = false;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Correct way to use is: <FormatFile> <XMLoutputout>");
            System.err.println("For example: runner.jme runner.xml");
            return;
        }
        File inFile = new File(args[0]);
        File outFile = new File(args[1]);
        if (!inFile.canRead()) {
            System.err.println("Cannot read input file " + inFile);
            return;
        }
        try {
            System.out.println("Converting file " + inFile + " to " + outFile);
            new BinaryToXML().sendBinarytoXML(new FileInputStream(inFile), new FileWriter(outFile));
        }
        catch (IOException e) {
            System.err.println("Unable to convert:" + e);
            return;
        }
        System.out.println("Conversion complete!");
    }

    public void sendBinarytoXML(InputStream binFile, Writer XML) throws IOException {
        this.myIn = new DataInputStream(binFile);
        this.XMLFile = XML;
        this.tabCount = 0;
        this.currentLine = new StringBuffer();
        this.readHeader();
        while (this.readPart()) {
        }
        XML.close();
    }

    private boolean readPart() throws IOException {
        byte flag = this.myIn.readByte();
        if (flag == 0) {
            String currentTag = this.myIn.readUTF();
            this.currentLine.append('<').append(currentTag).append(' ');
            int numTags = this.myIn.readByte();
            for (int i = 0; i < numTags; ++i) {
                String currentAttrib = this.myIn.readUTF();
                this.currentLine.append(currentAttrib).append("=\"");
                this.readData();
                this.currentLine.append("\" ");
            }
            this.currentLine.append('>');
            this.writeLine();
            this.tabCount = (short)(this.tabCount + 1);
            return true;
        }
        if (flag == 1) {
            this.tabCount = (short)(this.tabCount - 1);
            this.currentLine.append("</").append(this.myIn.readUTF()).append('>');
            this.writeLine();
            return true;
        }
        if (flag == 2) {
            return false;
        }
        throw new IOException("Unknown flag read: " + flag);
    }

    private void readData() throws IOException {
        byte type = this.myIn.readByte();
        switch (type) {
            case 3: {
                this.currentLine.append(this.myIn.readUTF());
                break;
            }
            case 2: {
                this.readColorArray();
                break;
            }
            case 4: {
                this.readIntArray();
                break;
            }
            case 1: {
                this.readVec2fArray();
                break;
            }
            case 0: {
                this.readVec3fArray();
                break;
            }
            case 7: {
                this.currentLine.append(this.myIn.readFloat());
                break;
            }
            case 6: {
                this.readQuat();
                break;
            }
            case 8: {
                this.readColor();
                break;
            }
            case 9: {
                this.currentLine.append(this.myIn.readUTF());
                break;
            }
            case 5: {
                this.readVec3f();
                break;
            }
            case 10: {
                this.currentLine.append(this.myIn.readInt());
                break;
            }
            case 11: {
                this.currentLine.append(this.myIn.readBoolean());
                break;
            }
            case 12: {
                this.readQuatArray();
                break;
            }
            case 13: {
                this.readByteArray();
                break;
            }
            case 14: {
                this.readShortArray();
                break;
            }
            case 15: {
                this.readVec2f();
                break;
            }
            case 16: {
                this.readMatrix3f();
                break;
            }
            default: {
                throw new IOException("Unknown data type:" + type);
            }
        }
    }

    private void readMatrix3f() throws IOException {
        for (int i = 0; i < 9; ++i) {
            this.currentLine.append(this.myIn.readFloat());
            if (i == 8) continue;
            this.currentLine.append(' ');
        }
    }

    private void readShortArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            this.currentLine.append(this.myIn.readShort());
            if (i == length - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readByteArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            this.currentLine.append(this.myIn.readByte());
            if (i == length - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readQuatArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == length - 1 && j == 3) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readColor() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readQuat() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readVec3f() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
        this.currentLine.append(' ').append(this.myIn.readFloat());
    }

    private void readVec2f() throws IOException {
        this.currentLine.append(this.myIn.readFloat()).append(' ').append(this.myIn.readFloat());
    }

    private void readIntArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            this.currentLine.append(Integer.toString(this.myIn.readInt()));
            if (i == length - 1) continue;
            this.currentLine.append(' ');
        }
    }

    private void readVec2fArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == length - 1 && j == 1) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readColorArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == length - 1 && j == 3) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readVec3fArray() throws IOException {
        int length = this.myIn.readInt();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.currentLine.append(Float.toString(this.myIn.readFloat()));
                if (i == length - 1 && j == 2) continue;
                this.currentLine.append(' ');
            }
        }
    }

    private void readHeader() throws IOException {
        if (1234567L != this.myIn.readLong()) {
            throw new IOException("Header data doesn't match");
        }
    }

    private void writeLine() throws IOException {
        for (int i = 0; i < this.tabCount; ++i) {
            this.XMLFile.write(9);
        }
        this.currentLine.append('\n');
        this.XMLFile.write(this.currentLine.toString());
        this.currentLine.setLength(0);
    }
}

