/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.math;

import com.jme.math.Vector3f;
import com.jmex.font3d.math.PlanarEdge;
import com.jmex.font3d.math.PlanarVertex;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoublyConnectedEdgeList<Vertex extends PlanarVertex, Edge extends PlanarEdge> {
    private static final Logger logger = Logger.getLogger(DoublyConnectedEdgeList.class.getName());
    ArrayList<Vertex> vertices = new ArrayList();
    ArrayList<Edge> edges = new ArrayList();

    public abstract Vertex createVertex(int var1, Vector3f var2);

    public abstract Edge createEdge(Vertex var1, boolean var2);

    public Vertex addVertex(Vector3f vector3f) {
        Vertex Vertex = this.createVertex(this.vertices.size(), vector3f);
        this.vertices.add(Vertex);
        return Vertex;
    }

    public Edge addEdge(int n, int n2) {
        PlanarVertex planarVertex = (PlanarVertex)this.vertices.get(n);
        PlanarVertex planarVertex2 = (PlanarVertex)this.vertices.get(n2);
        PlanarEdge planarEdge = planarVertex.getEdge(planarVertex2);
        boolean bl = false;
        if (planarEdge == null) {
            planarEdge = this.createEdge(planarVertex, true);
            bl = true;
        } else {
            planarEdge.realedge = true;
            logger.info("Added an duplicate edge: (" + n + " -> " + n2 + ")");
        }
        PlanarEdge planarEdge2 = planarVertex2.getEdge(planarVertex);
        boolean bl2 = false;
        if (planarEdge2 == null) {
            planarEdge2 = this.createEdge(planarVertex2, false);
            bl2 = true;
        } else {
            logger.info("Added a duplicate edge (TWIN): (" + n2 + " -> " + n + ")");
        }
        planarEdge.setTwin(planarEdge2);
        if (bl) {
            planarVertex.addOutgoingEdge(planarEdge);
        } else if (bl2) {
            throw new RuntimeException("Damng, created a twin to an existing edge, that can never happen");
        }
        this.edges.add(planarEdge);
        this.edges.add(planarEdge2);
        return (Edge)planarEdge;
    }

    public ArrayList<Vertex> getVertices() {
        return this.vertices;
    }
}

