/*
 * Decompiled with CFR 0.152.
 */
package mdxreader;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndian
implements DataInput {
    private InputStream in;

    public LittleEndian(InputStream in) {
        this.in = in;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readUnsignedByte() > 0;
    }

    @Override
    public byte readByte() throws IOException {
        int value = this.in.read();
        if (value < 0) {
            throw new EOFException();
        }
        return (byte)value;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int value = this.in.read();
        if (value < 0) {
            throw new EOFException();
        }
        return value;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int total;
        int cur = 0;
        for (total = 0; total < n && (cur = (int)this.in.skip(n - total)) > 0; total += cur) {
        }
        return total;
    }

    @Override
    public char readChar() throws IOException {
        return (char)this.readUnsignedShort();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public int readInt() throws IOException {
        return this.readUnsignedByte() | this.readUnsignedByte() << 8 | this.readUnsignedByte() << 16 | this.readUnsignedByte() << 24;
    }

    @Override
    public long readLong() throws IOException {
        return (long)this.readInt() | ((long)this.readInt() & 0xFFFFFFFFL) << 32;
    }

    @Override
    public short readShort() throws IOException {
        return (short)(this.readUnsignedByte() | this.readUnsignedByte() << 8);
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readUnsignedByte() | this.readUnsignedByte() << 8;
    }
}

