/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeNumber;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaInt
implements SchemaTypeNumber {
    protected int value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaInt() {
        this.setEmpty();
    }

    public SchemaInt(SchemaInt schemaInt) {
        this.value = schemaInt.value;
        this.isempty = schemaInt.isempty;
        this.isnull = schemaInt.isnull;
    }

    public SchemaInt(int n) {
        this.setValue(n);
    }

    public SchemaInt(String string) {
        this.parse(string);
    }

    public SchemaInt(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaInt(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = Integer.parseInt(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).intValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaInt)) {
            return false;
        }
        return this.value == ((SchemaInt)object).value;
    }

    public Object clone() {
        return new SchemaInt(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return Integer.toString(this.value);
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaInt)object);
    }

    public int compareTo(SchemaInt schemaInt) {
        return new Integer(this.value).compareTo(new Integer(schemaInt.value));
    }

    public int numericType() {
        return 1;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }
}

