/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.xml.types;

import com.jmex.xml.types.SchemaNormalizedString;
import com.jmex.xml.types.SchemaType;
import com.jmex.xml.types.SchemaTypeNumber;
import com.jmex.xml.types.StringParseException;
import com.jmex.xml.types.TypesIncompatibleException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaDecimal
implements SchemaTypeNumber {
    protected BigDecimal value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaDecimal() {
        this.setEmpty();
    }

    public SchemaDecimal(SchemaDecimal schemaDecimal) {
        this.value = schemaDecimal.value;
        this.isempty = schemaDecimal.isempty;
        this.isnull = schemaDecimal.isnull;
    }

    public SchemaDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    public SchemaDecimal(double d) {
        this.setValue(d);
    }

    public SchemaDecimal(String string) {
        this.parse(string);
    }

    public SchemaDecimal(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDecimal(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public void setValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.value = bigDecimal;
            this.isempty = false;
            this.isnull = false;
        }
    }

    public void setValue(double d) {
        this.value = new BigDecimal(d);
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string) {
        String string2 = SchemaNormalizedString.normalize((byte)3, string);
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = new BigDecimal(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).bigDecimalValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = BigDecimal.valueOf(0L);
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = BigDecimal.valueOf(0L);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaDecimal)) {
            return false;
        }
        return this.value.compareTo(((SchemaDecimal)object).value) == 0;
    }

    public Object clone() {
        return new SchemaDecimal(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        String string = this.value.toString();
        int n = string.indexOf(46);
        if (string.length() <= 0 || n <= 0) {
            return string;
        }
        int n2 = string.length();
        for (n2 = string.length() - 1; n2 > n && string.charAt(n2) == '0'; --n2) {
        }
        if (string.charAt(n2) == '.') {
            --n2;
        }
        return string.substring(0, n2 + 1);
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value.compareTo(new BigDecimal(0)) != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaDecimal)object);
    }

    public int compareTo(SchemaDecimal schemaDecimal) {
        return this.value.compareTo(schemaDecimal.value);
    }

    public void reduceScale() {
        if (this.value.scale() <= 0) {
            return;
        }
        String string = this.value.toString();
        int n = string.length() - 1;
        int n2 = 0;
        while (n >= 0 && string.substring(n, n + 1).equals("0")) {
            --n;
            ++n2;
        }
        this.value = this.value.setScale(this.value.scale() - n2);
    }

    public int numericType() {
        return 6;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value.toBigInteger();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }
}

