/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.subtitle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTList;
import jp.sourceforge.akjrcp.subtitle.srt.SRTObject;
import jp.sourceforge.akjrcp.subtitle.srt.SRTParser;
import jp.sourceforge.akjrcp.subtitle.sub.SUBParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class SubUtils {
    public static int SUB = 0;
    public static int SRT = 1;
    public static final double NTSC_FRAME_RATE = 29.97;
    public static final double PAL_FRAME_RATE = 25.0;

    public static String[] getDefaultImageExtensions() {
        return new String[]{".png", ".gif", ".bmp", ".jpg"};
    }

    public static int getSubType(File file) {
        if (file.getName().toLowerCase().endsWith(".srt")) {
            return SRT;
        }
        return SUB;
    }

    public static long countContainTime(StandardSubObject object1, StandardSubObject object2) {
        long result = 0L;
        long i = object1.getStartTime();
        while (i <= object1.getEndTime()) {
            if (i >= object2.getStartTime() && i <= object2.getEndTime()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static long getTotalTime(StandardSubObject[] subs) {
        long result = 0L;
        int i = 0;
        while (i < subs.length) {
            result += subs[i].getEndTime() - subs[i].getStartTime();
            ++i;
        }
        return result;
    }

    public static String toTimeString(long frame) {
        long hour = frame / 3600000L;
        long remain = frame % 3600000L;
        long minute = remain / 60000L;
        long second = (remain %= 60000L) / 1000L;
        remain %= 1000L;
        String result = "";
        result = hour < 10L ? "0" + hour : String.valueOf(result) + hour;
        result = String.valueOf(result) + ":";
        result = minute < 10L ? String.valueOf(result) + "0" + minute : String.valueOf(result) + minute;
        result = String.valueOf(result) + ":";
        result = second < 10L ? String.valueOf(result) + "0" + second : String.valueOf(result) + second;
        long milli = remain * 60L / 1000L;
        result = milli < 10L ? String.valueOf(result) + ":0" + milli : String.valueOf(result) + ":" + milli;
        return result;
    }

    public static void saveAsSrt(List<StandardSubObject> standardList, File file) throws IOException {
        StringBuffer srtText = new StringBuffer();
        Object[] subList = standardList.toArray(new StandardSubObject[standardList.size()]);
        Arrays.sort(subList);
        int index = 1;
        int i = 0;
        while (i < subList.length) {
            SRTObject srt = new SRTObject();
            String text = ((StandardSubObject)subList[i]).getText();
            text = StringUtils.replace((String)text, (String)"\r\n", (String)"_SYSTEM_TMP_RN_");
            text = StringUtils.replace((String)text, (String)"\n", (String)"\r\n");
            text = StringUtils.replace((String)text, (String)"_SYSTEM_TMP_RN_", (String)"\r\n");
            srt.setText(text);
            srt.setStartTime(((StandardSubObject)subList[i]).getStartTime());
            srt.setEndTime(((StandardSubObject)subList[i]).getEndTime());
            srt.setIndex(index);
            srtText.append(srt.toString());
            srtText.append("\r\n");
            ++index;
            ++i;
        }
        FileUtils.writeStringToFile((File)file, (String)srtText.toString());
    }

    public static List loadSub(File file) throws IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        int type = SubUtils.getSubType(file);
        if (type == SUB) {
            SUBParser parser = new SUBParser();
            parser.parse(file);
            return parser.getSubDataList();
        }
        if (type == SRT) {
            SRTParser parser = new SRTParser();
            try {
                SRTList list = parser.parse(new FileReader(file));
                return list.convertStandardSubtitleDataList();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

