/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WildCard {
    private String pattern;
    private String javaPattern;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.javaPattern = WildCard.toJavaPattern(pattern);
    }

    public WildCard(String text) {
        this.setPattern(text);
    }

    public boolean match(String text) {
        Pattern pattern = Pattern.compile(this.javaPattern, 2);
        Matcher matcher = pattern.matcher(text);
        return matcher.matches();
    }

    public static WildCard[] parseFileFilters(String text) {
        String substring;
        int first;
        int last;
        if (text.indexOf("(") != -1 && (last = text.indexOf(")", (first = text.indexOf("(")) + 1)) != -1 && (substring = text.substring(first + 1, last)).length() > 0) {
            String[] splits = substring.split(",");
            WildCard[] result = new WildCard[splits.length];
            int i = 0;
            while (i < splits.length) {
                result[i] = new WildCard(splits[i]);
                ++i;
            }
            return result;
        }
        return new WildCard[0];
    }

    public static WildCard[] parseExtensions(String text) {
        String[] extension = text.split(";");
        WildCard[] rets = new WildCard[extension.length];
        int i = 0;
        while (i < rets.length) {
            rets[i] = new WildCard(extension[i]);
            ++i;
        }
        return rets;
    }

    public static String toJavaPattern(String pattern) {
        String result = "^";
        char[] metachar = new char[]{'$', '^', '[', ']', '(', ')', '+', '.', '\\'};
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            boolean isMeta = false;
            int j = 0;
            while (j < metachar.length) {
                if (ch == metachar[j]) {
                    result = String.valueOf(result) + "\\" + ch;
                    isMeta = true;
                    break;
                }
                ++j;
            }
            if (!isMeta) {
                result = ch == '*' ? String.valueOf(result) + ".*" : String.valueOf(result) + ch;
            }
            ++i;
        }
        result = String.valueOf(result) + "$";
        return result;
    }
}

