/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class BetterFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    public synchronized String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer();
        this.dat.setTime(logRecord.getMillis());
        this.args[0] = this.dat;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, stringBuffer2, (FieldPosition)null);
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(" [");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append("] ");
        if (logRecord.getSourceClassName() != null) {
            stringBuffer.append(logRecord.getSourceClassName());
        } else {
            stringBuffer.append(logRecord.getLoggerName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append("->");
            stringBuffer.append(logRecord.getSourceMethodName());
            stringBuffer.append("()");
        }
        stringBuffer.append(" - ");
        String string = this.formatMessage(logRecord);
        stringBuffer.append(logRecord.getLevel().getLocalizedName());
        stringBuffer.append(": ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null) {
            stringBuffer.append("{");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(objectArray[i]);
                if (i >= objectArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("}");
        }
        if (logRecord.getThrown() != null) {
            stringBuffer.append(this.lineSeparator);
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                logRecord.getThrown().printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        stringBuffer.append(this.lineSeparator);
        return stringBuffer.toString();
    }

    private void visit(StringBuffer stringBuffer, ThreadGroup threadGroup, int n) {
        ThreadGroup[] threadGroupArray;
        int n2;
        int n3 = threadGroup.activeCount();
        Thread[] threadArray = new Thread[n3 * 2];
        n3 = threadGroup.enumerate(threadArray, false);
        for (n2 = 0; n2 < n3; ++n2) {
            threadGroupArray = threadArray[n2];
            stringBuffer.append(threadGroupArray.getName() + "[" + threadGroupArray.getId() + "]");
            stringBuffer.append(this.lineSeparator);
        }
        n2 = threadGroup.activeGroupCount();
        threadGroupArray = new ThreadGroup[n2 * 2];
        n2 = threadGroup.enumerate(threadGroupArray, false);
        for (int i = 0; i < n2; ++i) {
            this.visit(stringBuffer, threadGroupArray[i], n + 1);
        }
    }
}

