/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.GameTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameTaskQueue {
    public static final String RENDER = "render";
    public static final String UPDATE = "update";
    private ConcurrentLinkedQueue<GameTask> queue = new ConcurrentLinkedQueue();
    private boolean executeAll = false;

    public boolean isExecuteAll() {
        return this.executeAll;
    }

    public void setExecuteAll(boolean bl) {
        this.executeAll = bl;
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        GameTask<V> gameTask = new GameTask<V>(callable);
        this.queue.add(gameTask);
        return gameTask;
    }

    public void execute() {
        GameTask gameTask = this.queue.poll();
        do {
            if (gameTask == null) {
                return;
            }
            while (gameTask.isCancelled()) {
                gameTask = this.queue.poll();
                if (gameTask != null) continue;
                return;
            }
            gameTask.invoke();
        } while (this.executeAll && (gameTask = this.queue.poll()) != null);
    }
}

