/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl.shader;

import com.jme.util.shader.ShaderVariable;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat2;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat3;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat4;
import com.jme.util.shader.uniformtypes.ShaderVariableInt;
import com.jme.util.shader.uniformtypes.ShaderVariableInt2;
import com.jme.util.shader.uniformtypes.ShaderVariableInt3;
import com.jme.util.shader.uniformtypes.ShaderVariableInt4;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix2;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix3;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix4;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerByte;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerFloat;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerInt;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerShort;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;

public class LWJGLShaderUtil {
    private static final Logger logger = Logger.getLogger(LWJGLShaderUtil.class.getName());

    public static void updateShaderUniform(ShaderVariable shaderVariable) {
        if (shaderVariable instanceof ShaderVariableInt) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableInt4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableInt4)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableFloat4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableFloat4)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix2) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix2)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix3) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix3)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariableMatrix4) {
            LWJGLShaderUtil.updateShaderUniform((ShaderVariableMatrix4)shaderVariable);
        } else {
            logger.warning("updateShaderUniform: Unknown shaderVariable type!");
        }
    }

    public static void updateUniformLocation(ShaderVariable shaderVariable, int n) {
        if (shaderVariable.variableID == -1) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(shaderVariable.name.getBytes().length + 1));
            byteBuffer.clear();
            byteBuffer.put(shaderVariable.name.getBytes());
            byteBuffer.rewind();
            shaderVariable.variableID = ARBShaderObjects.glGetUniformLocationARB((int)n, (ByteBuffer)byteBuffer);
            if (shaderVariable.variableID == -1) {
                logger.severe("Shader uniform [" + shaderVariable.name + "] could not be located in shader");
            }
        }
    }

    private static void updateShaderUniform(ShaderVariableInt shaderVariableInt) {
        ARBShaderObjects.glUniform1iARB((int)shaderVariableInt.variableID, (int)shaderVariableInt.value1);
    }

    private static void updateShaderUniform(ShaderVariableInt2 shaderVariableInt2) {
        ARBShaderObjects.glUniform2iARB((int)shaderVariableInt2.variableID, (int)shaderVariableInt2.value1, (int)shaderVariableInt2.value2);
    }

    private static void updateShaderUniform(ShaderVariableInt3 shaderVariableInt3) {
        ARBShaderObjects.glUniform3iARB((int)shaderVariableInt3.variableID, (int)shaderVariableInt3.value1, (int)shaderVariableInt3.value2, (int)shaderVariableInt3.value3);
    }

    private static void updateShaderUniform(ShaderVariableInt4 shaderVariableInt4) {
        ARBShaderObjects.glUniform4iARB((int)shaderVariableInt4.variableID, (int)shaderVariableInt4.value1, (int)shaderVariableInt4.value2, (int)shaderVariableInt4.value3, (int)shaderVariableInt4.value4);
    }

    private static void updateShaderUniform(ShaderVariableFloat shaderVariableFloat) {
        ARBShaderObjects.glUniform1fARB((int)shaderVariableFloat.variableID, (float)shaderVariableFloat.value1);
    }

    private static void updateShaderUniform(ShaderVariableFloat2 shaderVariableFloat2) {
        ARBShaderObjects.glUniform2fARB((int)shaderVariableFloat2.variableID, (float)shaderVariableFloat2.value1, (float)shaderVariableFloat2.value2);
    }

    private static void updateShaderUniform(ShaderVariableFloat3 shaderVariableFloat3) {
        ARBShaderObjects.glUniform3fARB((int)shaderVariableFloat3.variableID, (float)shaderVariableFloat3.value1, (float)shaderVariableFloat3.value2, (float)shaderVariableFloat3.value3);
    }

    private static void updateShaderUniform(ShaderVariableFloat4 shaderVariableFloat4) {
        ARBShaderObjects.glUniform4fARB((int)shaderVariableFloat4.variableID, (float)shaderVariableFloat4.value1, (float)shaderVariableFloat4.value2, (float)shaderVariableFloat4.value3, (float)shaderVariableFloat4.value4);
    }

    private static void updateShaderUniform(ShaderVariableMatrix2 shaderVariableMatrix2) {
        shaderVariableMatrix2.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix2ARB((int)shaderVariableMatrix2.variableID, (boolean)shaderVariableMatrix2.transpose, (FloatBuffer)shaderVariableMatrix2.matrixBuffer);
    }

    private static void updateShaderUniform(ShaderVariableMatrix3 shaderVariableMatrix3) {
        shaderVariableMatrix3.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix3ARB((int)shaderVariableMatrix3.variableID, (boolean)shaderVariableMatrix3.transpose, (FloatBuffer)shaderVariableMatrix3.matrixBuffer);
    }

    private static void updateShaderUniform(ShaderVariableMatrix4 shaderVariableMatrix4) {
        shaderVariableMatrix4.matrixBuffer.rewind();
        ARBShaderObjects.glUniformMatrix4ARB((int)shaderVariableMatrix4.variableID, (boolean)shaderVariableMatrix4.transpose, (FloatBuffer)shaderVariableMatrix4.matrixBuffer);
    }

    public static void updateAttributeLocation(ShaderVariable shaderVariable, int n) {
        if (shaderVariable.variableID == -1) {
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(shaderVariable.name.getBytes().length + 1));
            byteBuffer.clear();
            byteBuffer.put(shaderVariable.name.getBytes());
            byteBuffer.rewind();
            shaderVariable.variableID = ARBVertexShader.glGetAttribLocationARB((int)n, (ByteBuffer)byteBuffer);
            if (shaderVariable.variableID == -1) {
                logger.severe("Shader attribute [" + shaderVariable.name + "] could not be located in shader");
            }
        }
    }

    public static void updateShaderAttribute(ShaderVariable shaderVariable) {
        if (shaderVariable instanceof ShaderVariablePointerFloat) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerFloat)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerByte) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerByte)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerInt) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerInt)shaderVariable);
        } else if (shaderVariable instanceof ShaderVariablePointerShort) {
            LWJGLShaderUtil.updateShaderAttribute((ShaderVariablePointerShort)shaderVariable);
        } else {
            logger.warning("updateShaderAttribute: Unknown shaderVariable type!");
        }
    }

    private static void updateShaderAttribute(ShaderVariablePointerFloat shaderVariablePointerFloat) {
        shaderVariablePointerFloat.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB((int)shaderVariablePointerFloat.variableID);
        ARBVertexProgram.glVertexAttribPointerARB((int)shaderVariablePointerFloat.variableID, (int)shaderVariablePointerFloat.size, (boolean)shaderVariablePointerFloat.normalized, (int)shaderVariablePointerFloat.stride, (FloatBuffer)shaderVariablePointerFloat.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerByte shaderVariablePointerByte) {
        shaderVariablePointerByte.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB((int)shaderVariablePointerByte.variableID);
        ARBVertexProgram.glVertexAttribPointerARB((int)shaderVariablePointerByte.variableID, (int)shaderVariablePointerByte.size, (boolean)shaderVariablePointerByte.unsigned, (boolean)shaderVariablePointerByte.normalized, (int)shaderVariablePointerByte.stride, (ByteBuffer)shaderVariablePointerByte.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerInt shaderVariablePointerInt) {
        shaderVariablePointerInt.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB((int)shaderVariablePointerInt.variableID);
        ARBVertexProgram.glVertexAttribPointerARB((int)shaderVariablePointerInt.variableID, (int)shaderVariablePointerInt.size, (boolean)shaderVariablePointerInt.unsigned, (boolean)shaderVariablePointerInt.normalized, (int)shaderVariablePointerInt.stride, (IntBuffer)shaderVariablePointerInt.data);
    }

    private static void updateShaderAttribute(ShaderVariablePointerShort shaderVariablePointerShort) {
        shaderVariablePointerShort.data.rewind();
        ARBVertexProgram.glEnableVertexAttribArrayARB((int)shaderVariablePointerShort.variableID);
        ARBVertexProgram.glVertexAttribPointerARB((int)shaderVariablePointerShort.variableID, (int)shaderVariablePointerShort.size, (boolean)shaderVariablePointerShort.unsigned, (boolean)shaderVariablePointerShort.normalized, (int)shaderVariablePointerShort.stride, (ShortBuffer)shaderVariablePointerShort.data);
    }
}

