/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.math.Matrix3f;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.state.GLSLShaderDataLogic;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.shader.ShaderVariable;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat2;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat3;
import com.jme.util.shader.uniformtypes.ShaderVariableFloat4;
import com.jme.util.shader.uniformtypes.ShaderVariableInt;
import com.jme.util.shader.uniformtypes.ShaderVariableInt2;
import com.jme.util.shader.uniformtypes.ShaderVariableInt3;
import com.jme.util.shader.uniformtypes.ShaderVariableInt4;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix2;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix3;
import com.jme.util.shader.uniformtypes.ShaderVariableMatrix4;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerByte;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerFloat;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerInt;
import com.jme.util.shader.uniformtypes.ShaderVariablePointerShort;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GLSLShaderObjectsState
extends RenderState {
    private static final Logger logger = Logger.getLogger(GLSLShaderObjectsState.class.getName());
    protected ArrayList<ShaderVariable> shaderUniforms = new ArrayList();
    protected ArrayList<ShaderVariable> shaderAttributes = new ArrayList();
    protected GLSLShaderDataLogic shaderDataLogic;
    protected GeomBatch batch;

    public void setBatch(GeomBatch geomBatch) {
        this.batch = geomBatch;
    }

    public void setShaderDataLogic(GLSLShaderDataLogic gLSLShaderDataLogic) {
        this.shaderDataLogic = gLSLShaderDataLogic;
    }

    public abstract boolean isSupported();

    public void setUniform(String string, boolean bl) {
        ShaderVariableInt shaderVariableInt = this.getShaderUniform(string, ShaderVariableInt.class);
        shaderVariableInt.value1 = bl ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n) {
        ShaderVariableInt shaderVariableInt = this.getShaderUniform(string, ShaderVariableInt.class);
        shaderVariableInt.value1 = n;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f) {
        ShaderVariableFloat shaderVariableFloat = this.getShaderUniform(string, ShaderVariableFloat.class);
        shaderVariableFloat.value1 = f;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, boolean bl, boolean bl2) {
        ShaderVariableInt2 shaderVariableInt2 = this.getShaderUniform(string, ShaderVariableInt2.class);
        shaderVariableInt2.value1 = bl ? 1 : 0;
        shaderVariableInt2.value2 = bl2 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2) {
        ShaderVariableInt2 shaderVariableInt2 = this.getShaderUniform(string, ShaderVariableInt2.class);
        shaderVariableInt2.value1 = n;
        shaderVariableInt2.value2 = n2;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2) {
        ShaderVariableFloat2 shaderVariableFloat2 = this.getShaderUniform(string, ShaderVariableFloat2.class);
        shaderVariableFloat2.value1 = f;
        shaderVariableFloat2.value2 = f2;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, boolean bl, boolean bl2, boolean bl3) {
        ShaderVariableInt3 shaderVariableInt3 = this.getShaderUniform(string, ShaderVariableInt3.class);
        shaderVariableInt3.value1 = bl ? 1 : 0;
        shaderVariableInt3.value2 = bl2 ? 1 : 0;
        shaderVariableInt3.value3 = bl3 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2, int n3) {
        ShaderVariableInt3 shaderVariableInt3 = this.getShaderUniform(string, ShaderVariableInt3.class);
        shaderVariableInt3.value1 = n;
        shaderVariableInt3.value2 = n2;
        shaderVariableInt3.value3 = n3;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2, float f3) {
        ShaderVariableFloat3 shaderVariableFloat3 = this.getShaderUniform(string, ShaderVariableFloat3.class);
        shaderVariableFloat3.value1 = f;
        shaderVariableFloat3.value2 = f2;
        shaderVariableFloat3.value3 = f3;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ShaderVariableInt4 shaderVariableInt4 = this.getShaderUniform(string, ShaderVariableInt4.class);
        shaderVariableInt4.value1 = bl ? 1 : 0;
        shaderVariableInt4.value2 = bl2 ? 1 : 0;
        shaderVariableInt4.value3 = bl3 ? 1 : 0;
        shaderVariableInt4.value4 = bl4 ? 1 : 0;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2, int n3, int n4) {
        ShaderVariableInt4 shaderVariableInt4 = this.getShaderUniform(string, ShaderVariableInt4.class);
        shaderVariableInt4.value1 = n;
        shaderVariableInt4.value2 = n2;
        shaderVariableInt4.value3 = n3;
        shaderVariableInt4.value4 = n4;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2, float f3, float f4) {
        ShaderVariableFloat4 shaderVariableFloat4 = this.getShaderUniform(string, ShaderVariableFloat4.class);
        shaderVariableFloat4.value1 = f;
        shaderVariableFloat4.value2 = f2;
        shaderVariableFloat4.value3 = f3;
        shaderVariableFloat4.value4 = f4;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Vector2f vector2f) {
        ShaderVariableFloat2 shaderVariableFloat2 = this.getShaderUniform(string, ShaderVariableFloat2.class);
        shaderVariableFloat2.value1 = vector2f.x;
        shaderVariableFloat2.value2 = vector2f.y;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Vector3f vector3f) {
        ShaderVariableFloat3 shaderVariableFloat3 = this.getShaderUniform(string, ShaderVariableFloat3.class);
        shaderVariableFloat3.value1 = vector3f.x;
        shaderVariableFloat3.value2 = vector3f.y;
        shaderVariableFloat3.value3 = vector3f.z;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, ColorRGBA colorRGBA) {
        ShaderVariableFloat4 shaderVariableFloat4 = this.getShaderUniform(string, ShaderVariableFloat4.class);
        shaderVariableFloat4.value1 = colorRGBA.r;
        shaderVariableFloat4.value2 = colorRGBA.g;
        shaderVariableFloat4.value3 = colorRGBA.b;
        shaderVariableFloat4.value4 = colorRGBA.a;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Quaternion quaternion) {
        ShaderVariableFloat4 shaderVariableFloat4 = this.getShaderUniform(string, ShaderVariableFloat4.class);
        shaderVariableFloat4.value1 = quaternion.x;
        shaderVariableFloat4.value2 = quaternion.y;
        shaderVariableFloat4.value3 = quaternion.z;
        shaderVariableFloat4.value4 = quaternion.w;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float[] fArray, boolean bl) {
        if (fArray.length != 4) {
            return;
        }
        ShaderVariableMatrix2 shaderVariableMatrix2 = this.getShaderUniform(string, ShaderVariableMatrix2.class);
        shaderVariableMatrix2.matrixBuffer.clear();
        shaderVariableMatrix2.matrixBuffer.put(fArray[0]);
        shaderVariableMatrix2.matrixBuffer.put(fArray[1]);
        shaderVariableMatrix2.matrixBuffer.put(fArray[2]);
        shaderVariableMatrix2.matrixBuffer.put(fArray[3]);
        shaderVariableMatrix2.transpose = bl;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Matrix3f matrix3f, boolean bl) {
        ShaderVariableMatrix3 shaderVariableMatrix3 = this.getShaderUniform(string, ShaderVariableMatrix3.class);
        matrix3f.fillFloatBuffer(shaderVariableMatrix3.matrixBuffer);
        shaderVariableMatrix3.transpose = bl;
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Matrix4f matrix4f, boolean bl) {
        ShaderVariableMatrix4 shaderVariableMatrix4 = this.getShaderUniform(string, ShaderVariableMatrix4.class);
        matrix4f.fillFloatBuffer(shaderVariableMatrix4.matrixBuffer);
        shaderVariableMatrix4.transpose = bl;
        this.setNeedsRefresh(true);
    }

    public void clearUniforms() {
        this.shaderUniforms.clear();
    }

    public void setAttributePointer(String string, int n, boolean bl, int n2, FloatBuffer floatBuffer) {
        ShaderVariablePointerFloat shaderVariablePointerFloat = this.getShaderAttribute(string, ShaderVariablePointerFloat.class);
        shaderVariablePointerFloat.size = n;
        shaderVariablePointerFloat.normalized = bl;
        shaderVariablePointerFloat.stride = n2;
        shaderVariablePointerFloat.data = floatBuffer;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, ByteBuffer byteBuffer) {
        ShaderVariablePointerByte shaderVariablePointerByte = this.getShaderAttribute(string, ShaderVariablePointerByte.class);
        shaderVariablePointerByte.size = n;
        shaderVariablePointerByte.normalized = bl;
        shaderVariablePointerByte.unsigned = bl2;
        shaderVariablePointerByte.stride = n2;
        shaderVariablePointerByte.data = byteBuffer;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, IntBuffer intBuffer) {
        ShaderVariablePointerInt shaderVariablePointerInt = this.getShaderAttribute(string, ShaderVariablePointerInt.class);
        shaderVariablePointerInt.size = n;
        shaderVariablePointerInt.normalized = bl;
        shaderVariablePointerInt.unsigned = bl2;
        shaderVariablePointerInt.stride = n2;
        shaderVariablePointerInt.data = intBuffer;
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, ShortBuffer shortBuffer) {
        ShaderVariablePointerShort shaderVariablePointerShort = this.getShaderAttribute(string, ShaderVariablePointerShort.class);
        shaderVariablePointerShort.size = n;
        shaderVariablePointerShort.normalized = bl;
        shaderVariablePointerShort.unsigned = bl2;
        shaderVariablePointerShort.stride = n2;
        shaderVariablePointerShort.data = shortBuffer;
        this.setNeedsRefresh(true);
    }

    public void clearAttributes() {
        this.shaderAttributes.clear();
    }

    @Override
    public int getType() {
        return 14;
    }

    private <T extends ShaderVariable> T getShaderUniform(String string, Class<T> clazz) {
        T t = this.getShaderVariable(string, clazz, this.shaderUniforms);
        this.checkUniformSizeLimits();
        return t;
    }

    private <T extends ShaderVariable> T getShaderAttribute(String string, Class<T> clazz) {
        T t = this.getShaderVariable(string, clazz, this.shaderAttributes);
        this.checkAttributeSizeLimits();
        return t;
    }

    private <T extends ShaderVariable> T getShaderVariable(String string, Class<T> clazz, ArrayList<ShaderVariable> arrayList) {
        int n = arrayList.size();
        while (--n >= 0) {
            ShaderVariable shaderVariable = arrayList.get(n);
            if (!string.equals(shaderVariable.name)) continue;
            shaderVariable.needsRefresh = true;
            return (T)shaderVariable;
        }
        try {
            ShaderVariable shaderVariable = (ShaderVariable)clazz.newInstance();
            shaderVariable.name = string;
            arrayList.add(shaderVariable);
            return (T)shaderVariable;
        }
        catch (InstantiationException instantiationException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "getShaderVariable(name, classz, shaderVariableList)", "Exception", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "getShaderVariable(name, classz, shaderVariableList)", "Exception", illegalAccessException);
        }
        return null;
    }

    public void checkUniformSizeLimits() {
    }

    public void checkAttributeSizeLimits() {
    }

    public abstract void load(URL var1, URL var2);

    public abstract void load(String var1, String var2);

    @Override
    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.shaderUniforms, "shaderUniforms", new ArrayList());
        outputCapsule.writeSavableArrayList(this.shaderAttributes, "shaderAttributes", new ArrayList());
    }

    @Override
    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.shaderUniforms = inputCapsule.readSavableArrayList("shaderUniforms", new ArrayList());
        this.shaderAttributes = inputCapsule.readSavableArrayList("shaderAttributes", new ArrayList());
    }

    @Override
    public Class getClassTag() {
        return GLSLShaderObjectsState.class;
    }
}

