/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.batch;

import com.jme.math.Vector3f;
import com.jme.renderer.Renderer;
import com.jme.scene.batch.GeomBatch;
import com.jme.system.JmeException;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.IntBuffer;

public class QuadBatch
extends GeomBatch
implements Serializable,
Savable {
    private static final long serialVersionUID = 8486155454487030827L;
    public static final int QUADS = 1;
    public static final int QUAD_STRIP = 2;
    protected transient IntBuffer indexBuffer;
    private static Vector3f[] quads;
    private int mode = 1;
    private int quadQuantity;

    public void setMode(int n) {
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public static Vector3f[] getQuads() {
        return quads;
    }

    public static void setQuads(Vector3f[] vector3fArray) {
        quads = vector3fArray;
    }

    public IntBuffer getIndexBuffer() {
        return this.indexBuffer;
    }

    public void setIndexBuffer(IntBuffer intBuffer) {
        this.indexBuffer = intBuffer;
        this.recalcQuadQuantity();
    }

    protected void recalcQuadQuantity() {
        if (this.indexBuffer == null) {
            this.quadQuantity = 0;
            return;
        }
        switch (this.mode) {
            case 1: {
                this.quadQuantity = this.indexBuffer.limit() / 4;
                break;
            }
            case 2: {
                this.quadQuantity = this.indexBuffer.limit() / 2 - 1;
            }
        }
    }

    public int getQuadCount() {
        return this.quadQuantity;
    }

    public void setQuadQuantity(int n) {
        this.quadQuantity = n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getIndexBuffer() == null) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.getIndexBuffer().limit());
            this.getIndexBuffer().rewind();
            int n = this.getIndexBuffer().limit();
            for (int i = 0; i < n; ++i) {
                objectOutputStream.writeInt(this.getIndexBuffer().get());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n == 0) {
            this.setIndexBuffer(null);
        } else {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(n);
            for (int i = 0; i < n; ++i) {
                intBuffer.put(objectInputStream.readInt());
            }
            this.setIndexBuffer(intBuffer);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.indexBuffer, "indexBuffer", null);
        outputCapsule.write(this.mode, "mode", 1);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.indexBuffer = inputCapsule.readIntBuffer("indexBuffer", null);
        this.recalcQuadQuantity();
        this.mode = inputCapsule.readInt("mode", 1);
    }

    public int getType() {
        return 2304;
    }

    public void draw(Renderer renderer) {
        if (!this.isEnabled()) {
            return;
        }
        if (!renderer.isProcessingQueue() && renderer.checkAndAdd(this)) {
            return;
        }
        super.draw(renderer);
        renderer.draw(this);
    }

    public void getQuad(int n, int[] nArray) {
        if (n < this.getQuadCount() && nArray.length >= 4) {
            IntBuffer intBuffer = this.getIndexBuffer();
            nArray[0] = intBuffer.get(this.getVertIndex(n, 0));
            nArray[1] = intBuffer.get(this.getVertIndex(n, 1));
            nArray[2] = intBuffer.get(this.getVertIndex(n, 2));
            nArray[3] = intBuffer.get(this.getVertIndex(n, 3));
        }
    }

    public void getQuad(int n, Vector3f[] vector3fArray) {
        if (n < this.getQuadCount() && n >= 0) {
            for (int i = 0; i < 4; ++i) {
                if (vector3fArray[i] == null) {
                    vector3fArray[i] = new Vector3f();
                }
                BufferUtils.populateFromBuffer(vector3fArray[i], this.getVertexBuffer(), this.getIndexBuffer().get(this.getVertIndex(n, i)));
            }
        }
    }

    public Vector3f[] getMeshAsQuadsVertices(Vector3f[] vector3fArray) {
        int n = this.getQuadCount() * 4;
        if (vector3fArray == null || vector3fArray.length != n) {
            vector3fArray = new Vector3f[n];
        }
        this.getIndexBuffer().rewind();
        for (int i = 0; i < n; ++i) {
            if (vector3fArray[i] == null) {
                vector3fArray[i] = new Vector3f();
            }
            int n2 = this.getVertIndex(i / 4, i % 4);
            BufferUtils.populateFromBuffer(vector3fArray[i], this.getVertexBuffer(), this.getIndexBuffer().get(n2));
        }
        return vector3fArray;
    }

    protected int getVertIndex(int n, int n2) {
        switch (this.mode) {
            case 1: {
                return n * 4 + n2;
            }
            case 2: {
                return n * 2 + n2;
            }
        }
        throw new JmeException("mode is set to invalid type: " + this.mode);
    }

    public int getMaxIndex() {
        if (this.indexBuffer == null) {
            return -1;
        }
        switch (this.mode) {
            case 1: {
                return this.quadQuantity * 4;
            }
            case 2: {
                return 2 + this.quadQuantity * 2;
            }
        }
        return 0;
    }
}

