/*
 * Decompiled with CFR 0.152.
 */
package com.jme.math;

public final class Bessel {
    public static double j0(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = 5.7568490574E10 + d4 * (-1.3362590354E10 + d4 * (6.516196407E8 + d4 * (-1.121442418E7 + d4 * (77392.33017 + d4 * -184.9052456))));
            double d6 = 5.7568490411E10 + d4 * (1.029532985E9 + d4 * (9494680.718 + d4 * (59272.64853 + d4 * (267.8532712 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d7 * d7;
        double d9 = d3 - 0.785398164;
        double d10 = 1.0 + d8 * (-0.001098628627 + d8 * (2.734510407E-5 + d8 * (-2.073370639E-6 + d8 * 2.093887211E-7)));
        double d11 = -0.01562499995 + d8 * (1.430488765E-4 + d8 * (-6.911147651E-6 + d8 * (7.621095161E-7 - d8 * 9.34935152E-8)));
        return Math.sqrt(0.636619772 / d3) * (Math.cos(d9) * d10 - d7 * Math.sin(d9) * d11);
    }

    public static double j1(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d2 < 8.0) {
            double d4 = d * d;
            double d5 = d * (7.2362614232E10 + d4 * (-7.895059235E9 + d4 * (2.423968531E8 + d4 * (-2972611.439 + d4 * (15704.4826 + d4 * -30.16036606)))));
            double d6 = 1.44725228442E11 + d4 * (2.300535178E9 + d4 * (1.858330474E7 + d4 * (99447.43394 + d4 * (376.9991397 + d4 * 1.0))));
            return d5 / d6;
        }
        double d7 = 8.0 / d3;
        double d8 = d3 - 2.356194491;
        double d9 = d7 * d7;
        double d10 = 1.0 + d9 * (0.00183105 + d9 * (-3.516396496E-5 + d9 * (2.457520174E-6 + d9 * -2.40337019E-7)));
        double d11 = 0.04687499995 + d9 * (-2.002690873E-4 + d9 * (8.449199096E-6 + d9 * (-8.8228987E-7 + d9 * 1.05787412E-7)));
        double d12 = Math.sqrt(0.636619772 / d3) * (Math.cos(d8) * d10 - d7 * Math.sin(d8) * d11);
        if (d < 0.0) {
            d12 = -d12;
        }
        return d12;
    }

    public static double jn(int n, double d) {
        double d2;
        double d3 = 40.0;
        double d4 = 1.0E10;
        double d5 = 1.0E-10;
        if (n == 0) {
            return Bessel.j0(d);
        }
        if (n == 1) {
            return Bessel.j1(d);
        }
        double d6 = Math.abs(d);
        if (d6 == 0.0) {
            return 0.0;
        }
        if (d6 > (double)n) {
            double d7 = 2.0 / d6;
            double d8 = Bessel.j0(d6);
            double d9 = Bessel.j1(d6);
            for (int i = 1; i < n; ++i) {
                double d10 = (double)i * d7 * d9 - d8;
                d8 = d9;
                d9 = d10;
            }
            d2 = d9;
        } else {
            double d11 = 2.0 / d6;
            int n2 = 2 * ((n + (int)Math.sqrt(d3 * (double)n)) / 2);
            boolean bl = false;
            double d12 = 0.0;
            d2 = 0.0;
            double d13 = 0.0;
            double d14 = 1.0;
            for (int i = n2; i > 0; --i) {
                double d15 = (double)i * d11 * d14 - d13;
                d13 = d14;
                d14 = d15;
                if (Math.abs(d14) > d4) {
                    d14 *= d5;
                    d13 *= d5;
                    d2 *= d5;
                    d12 *= d5;
                }
                if (bl) {
                    d12 += d14;
                }
                boolean bl2 = bl = !bl;
                if (i != n) continue;
                d2 = d13;
            }
            d12 = 2.0 * d12 - d14;
            d2 /= d12;
        }
        return d < 0.0 && n % 2 == 1 ? -d2 : d2;
    }

    public static double y0(double d) {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = -2.957821389E9 + d2 * (7.062834065E9 + d2 * (-5.123598036E8 + d2 * (1.087988129E7 + d2 * (-86327.92757 + d2 * 228.4622733))));
            double d4 = 4.0076544269E10 + d2 * (7.452499648E8 + d2 * (7189466.438 + d2 * (47447.2647 + d2 * (226.1030244 + d2 * 1.0))));
            return d3 / d4 + 0.636619772 * Bessel.j0(d) * Math.log(d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 0.785398164;
        double d8 = 1.0 + d6 * (-0.001098628627 + d6 * (2.734510407E-5 + d6 * (-2.073370639E-6 + d6 * 2.093887211E-7)));
        double d9 = -0.01562499995 + d6 * (1.430488765E-4 + d6 * (-6.911147651E-6 + d6 * (7.621095161E-7 + d6 * -9.34945152E-8)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double y1(double d) {
        if (d < 8.0) {
            double d2 = d * d;
            double d3 = d * (-4.900604943E12 + d2 * (1.27527439E12 + d2 * (-5.153438139E10 + d2 * (7.349264551E8 + d2 * (-4237922.726 + d2 * 8511.937935)))));
            double d4 = 2.49958057E13 + d2 * (4.244419664E11 + d2 * (3.733650367E9 + d2 * (2.245904002E7 + d2 * (102042.605 + d2 * (354.9632885 + d2)))));
            return d3 / d4 + 0.636619772 * (Bessel.j1(d) * Math.log(d) - 1.0 / d);
        }
        double d5 = 8.0 / d;
        double d6 = d5 * d5;
        double d7 = d - 2.356194491;
        double d8 = 1.0 + d6 * (0.00183105 + d6 * (-3.516396496E-5 + d6 * (2.457520174E-6 + d6 * -2.40337019E-7)));
        double d9 = 0.04687499995 + d6 * (-2.002690873E-4 + d6 * (8.449199096E-6 + d6 * (-8.8228987E-7 + d6 * 1.05787412E-7)));
        return Math.sqrt(0.636619772 / d) * (Math.sin(d7) * d8 + d5 * Math.cos(d7) * d9);
    }

    public static double yn(int n, double d) {
        if (n == 0) {
            return Bessel.y0(d);
        }
        if (n == 1) {
            return Bessel.y1(d);
        }
        double d2 = 2.0 / d;
        double d3 = Bessel.y1(d);
        double d4 = Bessel.y0(d);
        for (int i = 1; i < n; ++i) {
            double d5 = (double)i * d2 * d3 - d4;
            d4 = d3;
            d3 = d5;
        }
        return d3;
    }
}

