/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.light.LightControllerManager;
import com.jme.light.LightManagement;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class LightStateController
extends Controller {
    private static final long serialVersionUID = 1L;
    private float timePass;
    private float updateInterval;
    private Spatial parent;

    public LightStateController() {
    }

    public LightStateController(Spatial spatial, LightManagement lightManagement) {
        this.parent = spatial;
        this.timePass = 0.0f;
        this.updateInterval = 0.0f;
    }

    public LightStateController(Spatial spatial, LightManagement lightManagement, float f, int n) {
        this.parent = spatial;
        this.timePass = n != 0 ? (float)((int)f % n) : 0.0f;
        this.updateInterval = f;
    }

    public void setUpdateInterval(float f) {
        this.updateInterval = f;
    }

    public float getUpdateInterval() {
        return this.updateInterval;
    }

    public void update(float f) {
        if (this.parent == null) {
            return;
        }
        this.timePass += f;
        if (this.parent.getLastFrustumIntersection() != 0 && (this.timePass >= this.updateInterval || f < 0.0f)) {
            this.timePass = 0.0f;
            LightControllerManager.lm.resortLightsFor((LightState)this.parent.getRenderState(3), this.parent);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.timePass, "timePass", 0.0f);
        outputCapsule.write(this.updateInterval, "updateInterval", 0.0f);
        outputCapsule.write(this.parent, "parent", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.timePass = inputCapsule.readFloat("timePass", 0.0f);
        this.updateInterval = inputCapsule.readFloat("updateInterval", 0.0f);
        this.parent = (Spatial)inputCapsule.readSavable("parent", null);
    }
}

