/*
 * Decompiled with CFR 0.152.
 */
package com.jme.light;

import com.jme.light.Light;
import com.jme.light.LightManagement;
import com.jme.light.LightStateController;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.system.DisplaySystem;
import java.util.ArrayList;

public class LightControllerManager {
    static ArrayList<LightStateController> controllerList = new ArrayList(1);
    static LightManagement lm = new LightManagement();

    public static void addController(LightStateController lightStateController) {
        controllerList.add(lightStateController);
    }

    public static void clearSpatials() {
        controllerList.clear();
    }

    public static void clearLights() {
        lm.reset();
    }

    public LightManagement getLightManagement() {
        return lm;
    }

    public static void addSpatial(Spatial spatial) {
        LightControllerManager.clearLSCs(spatial);
        LightStateController lightStateController = new LightStateController(spatial, lm);
        controllerList.add(lightStateController);
        spatial.addController(lightStateController);
        if (spatial.getRenderState(3) == null) {
            spatial.setRenderState(DisplaySystem.getDisplaySystem().getRenderer().createLightState());
        }
        if (spatial.getLightCombineMode() != 0) {
            spatial.setLightCombineMode(5);
        }
    }

    private static void clearLSCs(Spatial spatial) {
        for (int i = 0; i < spatial.getControllers().size(); ++i) {
            if (!(spatial.getController(i) instanceof LightStateController)) continue;
            spatial.removeController(spatial.getController(i));
            --i;
        }
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            int n = node.getQuantity();
            while (--n > 0) {
                LightControllerManager.clearLSCs(node.getChild(n));
            }
        }
    }

    public static void addLight(Light light) {
        if (!lm.contains(light)) {
            lm.addLight(light);
        }
    }

    public static void removeLight(Light light) {
        lm.removeLight(light);
    }

    public static void removeSpatial(Spatial spatial) {
        for (int i = 0; i < spatial.getControllers().size(); ++i) {
            if (!(spatial.getController(i) instanceof LightStateController)) continue;
            controllerList.remove(spatial.getController(i));
        }
    }

    public static void reset() {
        lm.reset();
    }
}

