/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.util;

import com.jme.input.ActionTrigger;
import com.jme.input.InputHandler;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.util.SyntheticTriggerContainer;
import com.jme.input.util.TriggerInfo;

class SyntheticTrigger
extends ActionTrigger {
    private SyntheticTriggerContainer container;
    private boolean permanentlyActiveIfRepeats;
    private int count;
    private TriggerInfo[] infos = new TriggerInfo[1];

    public SyntheticTrigger(SyntheticTriggerContainer syntheticTriggerContainer, InputHandler inputHandler, InputActionInterface inputActionInterface, boolean bl, boolean bl2) {
        super(inputHandler, syntheticTriggerContainer.getName(), inputActionInterface, bl);
        this.container = syntheticTriggerContainer;
        syntheticTriggerContainer.add(this);
        this.permanentlyActiveIfRepeats = bl2;
        if (bl2 && bl) {
            this.activate();
        }
        this.infos[0] = new TriggerInfo();
    }

    protected int getActionInvocationCount() {
        return this.count;
    }

    protected void remove() {
        super.remove();
        this.container.remove(this);
    }

    public void performAction(InputActionEvent inputActionEvent) {
        super.performAction(inputActionEvent);
        if (!this.allowRepeats) {
            this.count = 0;
        }
    }

    protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
        super.putTriggerInfo(inputActionEvent, n);
        inputActionEvent.setTriggerIndex(this.container.getIndex());
        TriggerInfo triggerInfo = this.infos[n];
        inputActionEvent.setTriggerCharacter(triggerInfo.character);
        inputActionEvent.setTriggerPressed(triggerInfo.pressed);
        inputActionEvent.setTriggerDelta(triggerInfo.delta);
        inputActionEvent.setTriggerPosition(triggerInfo.position);
        inputActionEvent.setTriggerData(triggerInfo.data);
    }

    protected final String getDeviceName() {
        return "Synthetic Input Device";
    }

    public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
        if (n == this.container.getIndex()) {
            TriggerInfo triggerInfo;
            if (!this.inputHandler.isEnabled()) {
                return;
            }
            if (this.allowRepeats) {
                triggerInfo = this.infos[0];
                this.count = 1;
            } else {
                if (this.count >= this.infos.length) {
                    TriggerInfo[] triggerInfoArray = this.infos;
                    this.infos = new TriggerInfo[this.count + 3];
                    System.arraycopy(triggerInfoArray, 0, this.infos, 0, triggerInfoArray.length);
                    for (int i = triggerInfoArray.length; i < this.infos.length; ++i) {
                        this.infos[i] = new TriggerInfo();
                    }
                }
                triggerInfo = this.infos[this.count];
                ++this.count;
            }
            triggerInfo.character = c;
            triggerInfo.position = f;
            triggerInfo.delta = f2;
            triggerInfo.pressed = bl;
            triggerInfo.data = object;
            if (!this.allowRepeats) {
                this.activate();
            } else if (!this.permanentlyActiveIfRepeats) {
                if (bl) {
                    this.activate();
                } else {
                    this.deactivate();
                }
            }
        }
    }
}

