/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input.joystick;

import com.jme.input.ActionTrigger;
import com.jme.input.InputHandler;
import com.jme.input.InputHandlerDevice;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.TriggersJoystickInputListener;

public class JoystickInputHandlerDevice
extends InputHandlerDevice {
    protected final Joystick joystick;
    private TriggersJoystickInputListener joystickListener;

    public JoystickInputHandlerDevice(Joystick joystick, String string) {
        super(string);
        this.joystick = joystick;
    }

    public synchronized TriggersJoystickInputListener getJoystickListener() {
        if (this.joystickListener == null) {
            this.joystickListener = new TriggersJoystickInputListener();
            this.joystickListener.activate();
        }
        return this.joystickListener;
    }

    protected void createTriggers(InputActionInterface inputActionInterface, int n, int n2, boolean bl, InputHandler inputHandler) {
        int n3;
        int n4;
        if (n != -1 && n < this.joystick.getAxisCount()) {
            String[] stringArray = this.joystick.getAxisNames();
            n4 = n == Integer.MIN_VALUE ? 0 : n;
            n3 = n == Integer.MIN_VALUE ? stringArray.length - 1 : n;
            for (int i = n4; i <= n3; ++i) {
                new JoystickAxisTrigger(inputHandler, stringArray[i], inputActionInterface, this.joystick, i, bl);
            }
        }
        if (n2 != -1 && n < this.joystick.getButtonCount()) {
            int n5 = n2 == Integer.MIN_VALUE ? 0 : n2;
            n4 = n2 == Integer.MIN_VALUE ? this.joystick.getButtonCount() - 1 : n2;
            for (n3 = n5; n3 <= n4; ++n3) {
                new JoystickButtonTrigger(inputHandler, "BUTTON" + n3, inputActionInterface, this.joystick, n3, bl);
            }
        }
    }

    protected class JoystickAxisTrigger
    extends ActionTrigger {
        private Joystick joystick;
        private int axis;
        private float delta;
        private float position;

        public JoystickAxisTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, Joystick joystick, int n, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.joystick = joystick;
            this.axis = n;
            JoystickInputHandlerDevice.this.getJoystickListener().add(this);
            if (bl) {
                this.activate();
            }
        }

        protected void remove() {
            super.remove();
            JoystickInputHandlerDevice.this.getJoystickListener().remove(this);
        }

        protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
            super.putTriggerInfo(inputActionEvent, n);
            inputActionEvent.setTriggerIndex(this.axis);
            inputActionEvent.setTriggerDelta(this.delta);
            inputActionEvent.setTriggerPosition(this.position);
        }

        protected String getDeviceName() {
            return this.joystick.getName();
        }

        public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
            if (object == this.joystick && n == this.axis) {
                this.delta = f - this.position;
                this.position = f;
                if (!this.allowRepeats) {
                    this.activate();
                }
            }
        }
    }

    protected class JoystickButtonTrigger
    extends ActionTrigger {
        private int button;
        private Joystick joystick;
        private boolean pressed;

        public JoystickButtonTrigger(InputHandler inputHandler, String string, InputActionInterface inputActionInterface, Joystick joystick, int n, boolean bl) {
            super(inputHandler, string, inputActionInterface, bl);
            this.button = n;
            this.joystick = joystick;
            JoystickInputHandlerDevice.this.getJoystickListener().add(this);
        }

        protected void remove() {
            super.remove();
            JoystickInputHandlerDevice.this.getJoystickListener().remove(this);
        }

        protected void putTriggerInfo(InputActionEvent inputActionEvent, int n) {
            super.putTriggerInfo(inputActionEvent, n);
            inputActionEvent.setTriggerIndex(this.button);
            inputActionEvent.setTriggerCharacter((char)(65 + this.button));
            inputActionEvent.setTriggerPressed(this.pressed);
        }

        protected String getDeviceName() {
            return this.joystick.getName();
        }

        public void checkActivation(char c, int n, float f, float f2, boolean bl, Object object) {
            if (object == this.joystick && n == this.button) {
                if (this.allowRepeats) {
                    if (bl) {
                        this.pressed = true;
                        this.activate();
                    } else {
                        this.deactivate();
                    }
                } else {
                    this.pressed = bl;
                    this.activate();
                }
            }
        }
    }
}

