/*
 * Decompiled with CFR 0.152.
 */
package com.jme.input;

import com.jme.input.Input;
import com.jme.input.KeyInputListener;
import com.jme.input.lwjgl.LWJGLKeyInput;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyInput
extends Input {
    public static final int KEY_ESCAPE = 1;
    public static final int KEY_1 = 2;
    public static final int KEY_2 = 3;
    public static final int KEY_3 = 4;
    public static final int KEY_4 = 5;
    public static final int KEY_5 = 6;
    public static final int KEY_6 = 7;
    public static final int KEY_7 = 8;
    public static final int KEY_8 = 9;
    public static final int KEY_9 = 10;
    public static final int KEY_0 = 11;
    public static final int KEY_MINUS = 12;
    public static final int KEY_EQUALS = 13;
    public static final int KEY_BACK = 14;
    public static final int KEY_TAB = 15;
    public static final int KEY_Q = 16;
    public static final int KEY_W = 17;
    public static final int KEY_E = 18;
    public static final int KEY_R = 19;
    public static final int KEY_T = 20;
    public static final int KEY_Y = 21;
    public static final int KEY_U = 22;
    public static final int KEY_I = 23;
    public static final int KEY_O = 24;
    public static final int KEY_P = 25;
    public static final int KEY_LBRACKET = 26;
    public static final int KEY_RBRACKET = 27;
    public static final int KEY_RETURN = 28;
    public static final int KEY_LCONTROL = 29;
    public static final int KEY_A = 30;
    public static final int KEY_S = 31;
    public static final int KEY_D = 32;
    public static final int KEY_F = 33;
    public static final int KEY_G = 34;
    public static final int KEY_H = 35;
    public static final int KEY_J = 36;
    public static final int KEY_K = 37;
    public static final int KEY_L = 38;
    public static final int KEY_SEMICOLON = 39;
    public static final int KEY_APOSTROPHE = 40;
    public static final int KEY_GRAVE = 41;
    public static final int KEY_LSHIFT = 42;
    public static final int KEY_BACKSLASH = 43;
    public static final int KEY_Z = 44;
    public static final int KEY_X = 45;
    public static final int KEY_C = 46;
    public static final int KEY_V = 47;
    public static final int KEY_B = 48;
    public static final int KEY_N = 49;
    public static final int KEY_M = 50;
    public static final int KEY_COMMA = 51;
    public static final int KEY_PERIOD = 52;
    public static final int KEY_SLASH = 53;
    public static final int KEY_RSHIFT = 54;
    public static final int KEY_MULTIPLY = 55;
    public static final int KEY_LMENU = 56;
    public static final int KEY_SPACE = 57;
    public static final int KEY_CAPITAL = 58;
    public static final int KEY_F1 = 59;
    public static final int KEY_F2 = 60;
    public static final int KEY_F3 = 61;
    public static final int KEY_F4 = 62;
    public static final int KEY_F5 = 63;
    public static final int KEY_F6 = 64;
    public static final int KEY_F7 = 65;
    public static final int KEY_F8 = 66;
    public static final int KEY_F9 = 67;
    public static final int KEY_F10 = 68;
    public static final int KEY_NUMLOCK = 69;
    public static final int KEY_SCROLL = 70;
    public static final int KEY_NUMPAD7 = 71;
    public static final int KEY_NUMPAD8 = 72;
    public static final int KEY_NUMPAD9 = 73;
    public static final int KEY_SUBTRACT = 74;
    public static final int KEY_NUMPAD4 = 75;
    public static final int KEY_NUMPAD5 = 76;
    public static final int KEY_NUMPAD6 = 77;
    public static final int KEY_ADD = 78;
    public static final int KEY_NUMPAD1 = 79;
    public static final int KEY_NUMPAD2 = 80;
    public static final int KEY_NUMPAD3 = 81;
    public static final int KEY_NUMPAD0 = 82;
    public static final int KEY_DECIMAL = 83;
    public static final int KEY_F11 = 87;
    public static final int KEY_F12 = 88;
    public static final int KEY_F13 = 100;
    public static final int KEY_F14 = 101;
    public static final int KEY_F15 = 102;
    public static final int KEY_KANA = 112;
    public static final int KEY_CONVERT = 121;
    public static final int KEY_NOCONVERT = 123;
    public static final int KEY_YEN = 125;
    public static final int KEY_NUMPADEQUALS = 141;
    public static final int KEY_CIRCUMFLEX = 144;
    public static final int KEY_AT = 145;
    public static final int KEY_COLON = 146;
    public static final int KEY_UNDERLINE = 147;
    public static final int KEY_KANJI = 148;
    public static final int KEY_STOP = 149;
    public static final int KEY_AX = 150;
    public static final int KEY_UNLABELED = 151;
    public static final int KEY_NUMPADENTER = 156;
    public static final int KEY_RCONTROL = 157;
    public static final int KEY_NUMPADCOMMA = 179;
    public static final int KEY_DIVIDE = 181;
    public static final int KEY_SYSRQ = 183;
    public static final int KEY_RMENU = 184;
    public static final int KEY_PAUSE = 197;
    public static final int KEY_HOME = 199;
    public static final int KEY_UP = 200;
    public static final int KEY_PRIOR = 201;
    public static final int KEY_PGUP = 201;
    public static final int KEY_LEFT = 203;
    public static final int KEY_RIGHT = 205;
    public static final int KEY_END = 207;
    public static final int KEY_DOWN = 208;
    public static final int KEY_NEXT = 209;
    public static final int KEY_PGDN = 209;
    public static final int KEY_INSERT = 210;
    public static final int KEY_DELETE = 211;
    public static final int KEY_LWIN = 219;
    public static final int KEY_RWIN = 220;
    public static final int KEY_APPS = 221;
    public static final int KEY_POWER = 222;
    public static final int KEY_SLEEP = 223;
    private static KeyInput instance;
    protected ArrayList<KeyInputListener> listeners;
    public static final String INPUT_LWJGL;
    public static final String INPUT_AWT = "com.jmex.awt.input.AWTKeyInput";
    private static Class provider;

    public static KeyInput get() {
        if (instance == null) {
            try {
                Constructor constructor = KeyInput.getProvider().getDeclaredConstructor(null);
                constructor.setAccessible(true);
                instance = (KeyInput)constructor.newInstance(null);
            }
            catch (Exception exception) {
                throw new RuntimeException("Error creating input provider", exception);
            }
        }
        return instance;
    }

    public static Class getProvider() {
        return provider;
    }

    public static void setProvider(String string) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if ("LWJGL".equals(string)) {
            string = INPUT_LWJGL;
        } else if ("AWT".equals(string)) {
            string = INPUT_AWT;
        }
        try {
            KeyInput.setProvider(Class.forName(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Unsupported provider: " + classNotFoundException.getMessage());
        }
    }

    public static void setProvider(Class clazz) {
        if (instance != null) {
            throw new IllegalStateException("Provider may only be changed before input is created!");
        }
        if (!KeyInput.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Specified class does not extend KeyInput");
        }
        provider = clazz;
    }

    public abstract boolean isKeyDown(int var1);

    public static boolean isInited() {
        return instance != null;
    }

    public abstract String getKeyName(int var1);

    public abstract int getKeyIndex(String var1);

    @Override
    public abstract void update();

    protected abstract void destroy();

    public void addListener(KeyInputListener keyInputListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(keyInputListener);
    }

    public void removeListener(KeyInputListener keyInputListener) {
        if (this.listeners != null) {
            this.listeners.remove(keyInputListener);
        }
    }

    public void removeListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }

    public boolean containsListener(KeyInputListener keyInputListener) {
        if (this.listeners != null) {
            return this.listeners.contains(keyInputListener);
        }
        return false;
    }

    public ArrayList<KeyInputListener> getListeners() {
        return this.listeners;
    }

    public static void destroyIfInitalized() {
        if (instance != null) {
            instance.destroy();
            instance = null;
        }
    }

    public boolean isShiftDown() {
        return this.isKeyDown(42) || this.isKeyDown(54);
    }

    public boolean isControlDown() {
        return this.isKeyDown(29) || this.isKeyDown(157);
    }

    static {
        INPUT_LWJGL = LWJGLKeyInput.class.getName();
        provider = LWJGLKeyInput.class;
    }
}

