/*
 * Decompiled with CFR 0.152.
 */
package com.jme.app;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class VariableTimestepGame
extends AbstractGame {
    private static final Logger logger = Logger.getLogger(VariableTimestepGame.class.getName());
    private Timer timer;
    private float frametime;

    public float getFramesPerSecond() {
        return 1.0f / this.frametime;
    }

    private void updateTime() {
        this.timer.update();
        this.frametime = this.timer.getTimePerFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        logger.info("Application started.");
        try {
            this.getAttributes();
            this.initSystem();
            this.assertDisplayCreated();
            this.timer = Timer.getTimer();
            this.initGame();
            while (!this.finished && !this.display.isClosing()) {
                this.updateTime();
                InputSystem.update();
                this.update(this.frametime);
                this.render(-1.0f);
                this.display.getRenderer().displayBackBuffer();
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "start()", "Exception in game loop", throwable);
        }
        finally {
            this.cleanup();
        }
        logger.info("Application ending.");
        if (this.display != null) {
            this.display.reset();
        }
        this.quit();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.close();
        }
        System.exit(0);
    }

    protected abstract void update(float var1);

    protected abstract void render(float var1);

    protected abstract void initSystem();

    protected abstract void initGame();

    protected abstract void reinit();

    protected abstract void cleanup();
}

