/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.motiontools.poseEditor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import jp.sourceforge.akjrcp.motiontools.Messages;
import jp.sourceforge.akjrcp.motiontools.poseEditor.PoseFileChangeListener;

public class PoseSelectSwingWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private String path;
    private PoseFileChangeListener poseFileChangeListener;

    public PoseSelectSwingWindow(PoseFileChangeListener poseFileChangeListener) {
        this.poseFileChangeListener = poseFileChangeListener;
        this.setSize(400, 680);
        this.setVisible(false);
        this.setLayout(null);
        JPanel jPanel = new JPanel();
        jPanel.setLocation(0, 0);
        jPanel.setSize(400, 50);
        JButton jButton = new JButton(Messages.getString("refresh"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PoseSelectSwingWindow.this.setExportDir(PoseSelectSwingWindow.this.path);
            }
        });
        jPanel.add(jButton);
        this.add(jPanel);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setLocation(0, 50);
        this.scrollPane.setSize(400, 630);
        this.add(this.scrollPane);
        this.scrollPane.setVisible(true);
    }

    public String getExportDir() {
        return this.path;
    }

    public void setExportDir(String string) {
        this.path = string;
        if (this.scrollPane.getViewport().getView() != null) {
            this.scrollPane.getViewport().remove(this.scrollPane.getViewport().getView());
        }
        this.scrollPane.getViewport().setView(this.createTree(new File(string)));
    }

    public JTree createTree(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(file.getAbsolutePath());
        this.createTreeNode(defaultMutableTreeNode, file);
        final JTree jTree = new JTree(defaultMutableTreeNode);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() != 1 && mouseEvent.getClickCount() == 2) {
                    PoseSelectSwingWindow.this.poseChanged(treePath);
                }
            }
        };
        jTree.addMouseListener(mouseAdapter);
        return jTree;
    }

    public void poseChanged(TreePath treePath) {
        if (this.poseFileChangeListener != null) {
            try {
                File file = this.toPathFile(treePath);
                if (file.isFile()) {
                    this.poseFileChangeListener.loadPose(new FileInputStream(file));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    private File toPathFile(TreePath treePath) {
        String string = "";
        Object[] objectArray = treePath.getPath();
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i];
            if (i == objectArray.length - 1) continue;
            string = string + File.separatorChar;
        }
        return new File(string);
    }

    private DefaultMutableTreeNode createTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2;
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(file2.getName());
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    this.createTreeNode(defaultMutableTreeNode2, file2);
                    if (defaultMutableTreeNode2.getChildCount() != 0) continue;
                    defaultMutableTreeNode.remove(defaultMutableTreeNode2);
                    continue;
                }
                if (!this.isPoseFile(file2)) continue;
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(file2.getName());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        return defaultMutableTreeNode;
    }

    private boolean isPoseFile(File file) {
        return file.getName().endsWith(".txt");
    }
}

