/*
 * Decompiled with CFR 0.152.
 */
package model.animation;

import com.jme.math.Quaternion;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import model.SkeletalKeyFrame;
import model.Skeleton;
import model.animation.Animation;
import util.file.FileUtils;

public class SkeletalAnimation
extends Animation {
    private Quaternion rotation = new Quaternion();
    private Skeleton skeleton;
    private BitSet suppliedRotations = new BitSet();

    public SkeletalAnimation() {
    }

    public SkeletalAnimation(String name, Skeleton skeleton) {
        super(name);
        this.skeleton = skeleton;
    }

    public SkeletalKeyFrame firstSkeletal() {
        return (SkeletalKeyFrame)this.first();
    }

    public SkeletalKeyFrame getBaseFrameSkeletal() {
        return (SkeletalKeyFrame)this.baseFrame;
    }

    public Quaternion getMovementRotation() {
        return this.rotation;
    }

    public SkeletalKeyFrame getNearestItemSkeletal(int index) {
        return (SkeletalKeyFrame)this.getNearestKeyFrame(index);
    }

    public SkeletalKeyFrame getSkeletal(int index) {
        return (SkeletalKeyFrame)this.getKeyFrame(index);
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public BitSet getSuppliedRotations() {
        return this.suppliedRotations;
    }

    @Override
    public boolean isSkeletal() {
        return true;
    }

    public SkeletalKeyFrame lastSkeletal() {
        return (SkeletalKeyFrame)this.last();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        FileUtils.checkVersionByte(in, 1, 1);
        this.rotation = (Quaternion)in.readObject();
        this.suppliedRotations = (BitSet)in.readObject();
        this.skeleton = (Skeleton)in.readObject();
    }

    public void recalculateMovementRotation(int joint) {
        if (!this.suppliedRotations.get(0)) {
            this.rotation.set(0.0f, 0.0f, 0.0f, 1.0f);
            return;
        }
        int pos = 0;
        for (int i = 0; i < joint; ++i) {
            if (!this.suppliedRotations.get(i)) continue;
            ++pos;
        }
        this.rotation.set(this.lastSkeletal().rotations[pos]).addLocal(this.firstSkeletal().rotations[pos].inverse());
    }

    public void setSkeleton(Skeleton skeleton) {
        this.skeleton = skeleton;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(1);
        out.writeObject(this.rotation);
        out.writeObject(this.suppliedRotations);
        out.writeObject(this.skeleton);
    }

    @Override
    protected Animation copy(String name) {
        SkeletalAnimation copy = new SkeletalAnimation(name, this.skeleton);
        copy.suppliedRotations = this.suppliedRotations;
        copy.rotation = this.rotation;
        return copy;
    }
}

