/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.TransformMatrix;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import model.KeyFrame;
import model.Model;
import model.ModelTriMesh;
import model.ModelUtils;
import model.SkeletalModelInstance;
import model.Skin;
import model.animation.AnimationController;

public class ModelInstance
extends Node {
    private static final long serialVersionUID = 1L;
    private Skin skin;
    protected ModelTriMesh[] meshes;
    private Model model;
    protected SkeletalModelInstance parent;
    protected int parentBone;
    private TransformMatrix baseTransform = new TransformMatrix();
    private transient TransformMatrix tempTransform = new TransformMatrix();

    public ModelInstance(Model model) {
        super(model.getName());
        if (model.isSkeletal() != this.isSkeletal()) {
            throw new IllegalArgumentException("skeletal/non skeletal mismatch");
        }
        this.model = model;
        this.meshes = new ModelTriMesh[model.getMeshes().length];
        for (int i = 0; i < this.meshes.length; ++i) {
            Vector3f[] vertices = new Vector3f[model.getMeshes()[i].getVertexCount()];
            Vector3f[] normals = new Vector3f[vertices.length];
            for (int v = 0; v < vertices.length; ++v) {
                vertices[v] = new Vector3f();
                normals[v] = new Vector3f();
            }
            this.meshes[i] = new ModelTriMesh(model.getMeshes()[i].getName());
            this.meshes[i].setIndexBuffer(0, model.getMeshes()[i].getTriangleCorners());
            this.meshes[i].setVertexBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])vertices));
            this.meshes[i].setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])normals));
            for (int t = 0; t < model.getMeshes()[i].getTextureCount(); ++t) {
                this.meshes[i].setTextureBuffer(t, model.getMeshes()[i].getVertexTextureBuffer(t));
            }
            this.meshes[i].setNormalsMode(2);
            this.attachChild((Spatial)this.meshes[i]);
            this.setModelBound((BoundingVolume)new BoundingBox());
            this.updateModelBound();
        }
        this.setSkin(model.getDefaultSkin());
        this.loadBindFrame();
    }

    public void loadBindFrame() {
        Vector3f[] vertices = BufferUtils.getVector3Array((FloatBuffer)this.meshes[0].getVertexBuffer(0));
        KeyFrame bind = this.getModel().getBind();
        int vertexCount = bind.positions.length;
        TransformMatrix trans = this.getTransformation();
        if (ModelUtils.isIdentity(trans)) {
            for (int i = 0; i < vertexCount; ++i) {
                vertices[i].set(bind.positions[i]);
            }
        } else {
            for (int i = 0; i < vertexCount; ++i) {
                trans.multPoint(vertices[i].set(bind.positions[i]));
            }
        }
    }

    public TransformMatrix getTransformation() {
        if (this.parent == null) {
            return this.baseTransform;
        }
        this.tempTransform.set(this.baseTransform);
        this.tempTransform.combineWithParent(this.parent.getJointTransforms()[this.parentBone]);
        return this.tempTransform;
    }

    public TransformMatrix getBaseTransform() {
        return this.baseTransform;
    }

    public void setBaseTransform(TransformMatrix baseTransform) {
        this.baseTransform = baseTransform;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
        for (int i = 0; i < this.meshes.length; ++i) {
            this.meshes[i].setShader(skin.getShader(this.meshes[i].getName()));
        }
        this.updateRenderState();
    }

    public Skin getSkin() {
        return this.skin;
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isSkeletal() {
        return false;
    }

    public AnimationController addAnimationController() {
        AnimationController controller = new AnimationController(this);
        this.addController(controller);
        return controller;
    }

    public ModelTriMesh[] getMeshes() {
        return this.meshes;
    }
}

