/*
 * Decompiled with CFR 0.152.
 */
package model;

import com.jme.math.TransformMatrix;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import model.Mesh;
import model.ModelTriMesh;
import util.file.FileUtils;

public class BoneMesh
extends Mesh {
    private int triangleCount;
    private transient IntBuffer triangleCorners;
    private int[] triangleCornerArray;
    private int vertexCount;
    private Vector2f[][] vertexTextureCoords;
    private transient FloatBuffer[] vertexTextureBuffer;
    private int[] vertexJoint;
    private float[] vertexUseMultiplier;
    private Vector3f[] vertexOffset;
    private int textureCount = 1;

    public BoneMesh(String name) {
        super(name);
    }

    public BoneMesh(String name, int triangles, int vertices) {
        super(name);
        this.resetTriangleCount(triangles);
        this.resetVertexCount(vertices);
        this.resetTextureCount(1);
    }

    public void resetVertexCount(int vertexCount) {
        this.vertexCount = vertexCount;
        this.vertexTextureCoords = new Vector2f[vertexCount][];
        this.vertexJoint = new int[vertexCount];
        this.vertexOffset = new Vector3f[vertexCount];
        this.vertexUseMultiplier = new float[vertexCount];
        this.resetTextureCount(this.textureCount);
    }

    public void resetTriangleCount(int triangleCount) {
        this.triangleCount = triangleCount;
        this.triangleCornerArray = new int[triangleCount * 3];
        this.triangleCorners = ByteBuffer.allocateDirect(triangleCount * 3 * 4).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    @Override
    public void skinMesh(ModelTriMesh mesh, TransformMatrix[] transforms, boolean updateBounds) {
        Vector3f[] normals = null;
        if (mesh.getShader().requiresNormals()) {
            normals = BufferUtils.getVector3Array((FloatBuffer)mesh.getNormalBuffer(0));
        }
        Vector3f[] vectors = BufferUtils.getVector3Array((FloatBuffer)mesh.getVertexBuffer(0));
        int[] triangles = this.triangleCornerArray;
        float[] vertexUse = this.vertexUseMultiplier;
        FloatBuffer buf = mesh.getVertexBuffer(0);
        buf.clear();
        for (int v = 0; v < this.vertexCount; ++v) {
            Vector3f pos = vectors[v];
            if (normals != null) {
                normals[v].set(0.0f, 0.0f, 0.0f);
            }
            pos.set(this.vertexOffset[0]);
            transforms[this.vertexJoint[v]].multPoint(pos);
            buf.put(pos.x).put(pos.y).put(pos.z);
        }
        buf.flip();
        if (normals != null) {
            Vector3f first = new Vector3f();
            Vector3f second = new Vector3f();
            for (int i = 0; i < triangles.length; i += 3) {
                int v1 = triangles[i];
                int v2 = triangles[i + 1];
                int v3 = triangles[i + 2];
                first.set(vectors[v2]).subtractLocal(vectors[v1]);
                second.set(vectors[v3]).subtractLocal(vectors[v2]);
                first.crossLocal(second);
                first.normalizeLocal();
                normals[v1].addLocal(second.set(first).multLocal(vertexUse[v1]));
                normals[v2].addLocal(second.set(first).multLocal(vertexUse[v2]));
                normals[v3].addLocal(first.multLocal(vertexUse[v2]));
            }
            mesh.setNormalBuffer(0, BufferUtils.createFloatBuffer((Vector3f[])normals));
        }
        if (updateBounds) {
            mesh.updateModelBound();
        }
    }

    public int getTriangleCount() {
        return this.triangleCount;
    }

    @Override
    public int getVertexCount() {
        return this.vertexCount;
    }

    @Override
    public IntBuffer getTriangleCorners() {
        return this.triangleCorners;
    }

    @Override
    public int[] getTriangleCornerArray() {
        return this.triangleCornerArray;
    }

    public void updateTriangleCorners() {
        int i;
        this.triangleCorners.clear();
        this.triangleCorners.put(this.triangleCornerArray);
        this.triangleCorners.flip();
        int[] useCount = new int[this.vertexCount];
        for (i = 0; i < this.triangleCornerArray.length; ++i) {
            int n = this.triangleCornerArray[i];
            useCount[n] = useCount[n] + 1;
        }
        for (i = 0; i < this.vertexCount; ++i) {
            this.vertexUseMultiplier[i] = useCount[i] != 0 ? 1.0f / (float)useCount[i] : 0.0f;
        }
    }

    @Override
    public Vector2f[] getVertexTextureCoords(int index) {
        return this.vertexTextureCoords[index];
    }

    @Override
    public FloatBuffer getVertexTextureBuffer(int index) {
        return this.vertexTextureBuffer[index];
    }

    @Override
    public int getTextureCount() {
        return this.vertexTextureCoords.length;
    }

    public void resetTextureCount(int textureCount) {
        this.textureCount = textureCount;
        this.vertexTextureCoords = new Vector2f[textureCount][];
        this.vertexTextureBuffer = new FloatBuffer[textureCount];
        for (int i = 0; i < textureCount; ++i) {
            this.vertexTextureCoords[i] = new Vector2f[this.vertexCount];
            this.vertexTextureBuffer[i] = ByteBuffer.allocateDirect(8 * this.vertexCount).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
    }

    public void updateTextureBuffer(int index) {
        this.vertexTextureBuffer[index].clear();
        for (int i = 0; i < this.vertexTextureCoords[index].length; ++i) {
            Vector2f tempVect = this.vertexTextureCoords[index][i];
            if (tempVect != null) {
                this.vertexTextureBuffer[index].put(tempVect.x).put(tempVect.y);
                continue;
            }
            this.vertexTextureBuffer[index].put(0.0f).put(0.0f);
        }
        this.vertexTextureBuffer[index].flip();
    }

    public int[] getVertexJoint() {
        return this.vertexJoint;
    }

    public Vector3f[] getVertexOffset() {
        return this.vertexOffset;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        FileUtils.checkVersionByte(in, 1, 1);
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.triangleCornerArray);
        out.writeObject(this.vertexJoint);
        out.writeObject(this.vertexOffset);
        out.writeObject(this.vertexTextureCoords);
    }
}

