/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.wizards.exportimg;

import java.io.File;
import jp.sourceforge.akjrcp.commons.ui.AbstractFileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.commons.ui.widget.LayoutDataBuilder;
import jp.sourceforge.akjrcp.commons.ui.widget.WidgetBuilder;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;
import jp.sourceforge.akjrcp.text_douga.rcp.Messages;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SizeAndRate
extends WizardPage {
    private Text size;
    private Text fps;
    private FileDirChoicer inputVideo;

    protected SizeAndRate(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("exportimg.sizeandrate_title"));
        this.setDescription(Messages.getString("exportimg.sizeandrate_description"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayout((Layout)new GridLayout());
        this.setControl((Control)base);
        this.inputVideo = new FileDirChoicer(base, 0, 0, Messages.getString("exportimg.input"));
        this.inputVideo.setLayoutData((Object)LayoutDataBuilder.fillHorizontalGridData());
        this.inputVideo.addFileListChangeListener(new AbstractFileDirChoicer.FileStatusChangeListener(){

            public void addList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                SizeAndRate.this.setPageComplete(false);
                String ffmpeg = FFMpegUI.getFFmpegOrPureFFMpeg();
                if (ffmpeg != null) {
                    FLVInfomation info = new FFMpegFLVParser(ffmpeg).parseFile(new File(event.getFilePath()));
                    SizeAndRate.this.size.setText(String.valueOf(info.getVideoWidth()) + "x" + info.getVideoHeight());
                    SizeAndRate.this.fps.setText("" + info.getVideoRate());
                    SizeAndRate.this.setPageComplete(true);
                }
            }

            public void removeList(AbstractFileDirChoicer.FileStatusChangeEvent event) {
                SizeAndRate.this.size.setText("");
                SizeAndRate.this.fps.setText("");
            }
        });
        Composite p1 = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        WidgetBuilder.createLabel((Composite)p1, (String)Messages.getString("exportimg.size"));
        this.size = new Text(p1, 8);
        this.size.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
        Composite p2 = WidgetBuilder.createTwoGridLayoutComposite((Composite)base, (int)0);
        WidgetBuilder.createLabel((Composite)p2, (String)Messages.getString("exportimg.fps"));
        this.fps = new Text(p2, 8);
        this.fps.setLayoutData((Object)LayoutDataBuilder.hintGridData((int)200, (int)0));
    }
}

