/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.effect.VideoEffect;
import jp.sourceforge.akjrcp.text_douga.video.EffectableVideoData;
import jp.sourceforge.akjrcp.text_douga.video.VideoUtils;

public class ColorVideoData
extends EffectableVideoData {
    private double duration = 3.0;
    private AudioData audioData;
    private VideoEffect startEffect;
    private VideoEffect endEffect;
    private int bgColor = 0;

    @Override
    public void setStartEffect(VideoEffect startEffect) {
        this.startEffect = startEffect;
    }

    public String toString() {
        return "ColorVideoData:duration=" + this.duration + " bgColor=" + this.bgColor;
    }

    public ColorVideoData(int bgColor) {
        this.bgColor = bgColor;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public int writeData(File dir, DougaPreference preference, int startIndex, int maxframe) throws IOException {
        int wf = 0;
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        BufferedImage frameImage = new BufferedImage(preference.getWidth(), preference.getHeight(), 1);
        Graphics2D g2 = (Graphics2D)frameImage.getGraphics();
        g2.setColor(new Color(this.bgColor));
        g2.fillRect(0, 0, preference.getWidth(), preference.getHeight());
        int frames = 0;
        if (this.duration == -1.0) {
            frames = maxframe;
        } else {
            frames = new BigDecimal(preference.getFps()).multiply(new BigDecimal(this.duration)).intValue();
            if (maxframe != 0 && maxframe < frames) {
                frames = maxframe;
            }
        }
        wf = VideoUtils.copyImage(frameImage, dir, startIndex, frames);
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }

    @Override
    public AudioData getAudioData() {
        return this.audioData;
    }

    @Override
    public void setAudioData(AudioData audioData) {
        this.audioData = audioData;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    @Override
    public double getTotalTime() {
        return this.duration;
    }

    @Override
    public int writeData(VideoWriter writer, DougaPreference preference) throws IOException {
        int maxframe = Math.max(0, writer.getMaxFrame() - writer.getWrited());
        int startIndex = writer.getWrited() + 1;
        log.info((Object)("start writeData:maxframe=" + maxframe + " startIndex=" + startIndex));
        if (this.startEffect != null) {
            this.startEffect.setKeyFrame(startIndex);
        }
        int wf = 0;
        BufferedImage frameImage = new BufferedImage(preference.getWidth(), preference.getHeight(), 1);
        Graphics2D g2 = (Graphics2D)frameImage.getGraphics();
        g2.setColor(new Color(this.bgColor));
        g2.fillRect(0, 0, preference.getWidth(), preference.getHeight());
        int frames = 0;
        if (this.duration == -1.0) {
            frames = maxframe;
        } else {
            frames = new BigDecimal(preference.getFps()).multiply(new BigDecimal(this.duration)).intValue();
            if (maxframe != 0 && maxframe < frames) {
                frames = maxframe;
            }
        }
        log.info((Object)("copy image:" + frames + " it takes frames/60 seconds to finish copy"));
        wf = VideoUtils.copyImage(frameImage, this, writer, frames);
        if (this.audioData != null) {
            this.audioData.setSynchLength((double)wf / preference.getFps());
        }
        if (wf > 0) {
            if (this.endEffect != null) {
                this.endEffect.setKeyFrame(startIndex + wf - 1);
            }
        } else if (this.startEffect != null) {
            this.startEffect.setKeyFrame(-9999);
        }
        return wf;
    }
}

