/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;

public class LineTextData {
    private int width;
    private Font font;
    private String text;
    String[] texts;
    int[] styles;
    int[] returnPoint;
    byte[] charWidths;
    private char[] splitchars = new char[]{'\n', ' ', ':', ';', '.', ','};
    private boolean wrap = true;
    private boolean reanalyze = true;
    private int stringHeight;
    private int margin = 5;

    public int getTotalHeight() {
        if (this.texts == null || this.texts.length == 0) {
            return 0;
        }
        int ret = this.texts.length * this.font.getSize();
        return ret += this.texts.length - 1 * this.margin;
    }

    public LineTextData(int width, Font font) {
        this.width = width;
        this.font = font;
    }

    public void analyze(Graphics2D g2) {
        g2.setFont(this.font);
        this.charWidths = this.toCharByte(g2, this.getText());
        this.returnPoint = this.splitLine(g2);
        this.reanalyze = false;
    }

    public void paint(Graphics2D g2, int drawX, int drawY) {
        if (this.reanalyze) {
            this.analyze(g2);
        }
        g2.setFont(this.font);
        if (this.texts != null) {
            int dx = drawX;
            int dy = drawY;
            int index = 0;
            int j = 0;
            while (j < this.texts.length) {
                if (this.isReturn(j)) {
                    dx = drawX;
                    dy += this.font.getSize() + this.margin;
                }
                if (!this.texts[j].equals("\n")) {
                    int length = this.toWordLength(index, this.texts[j].length());
                    g2.drawString(this.texts[j], dx, dy);
                    dx += length;
                }
                index += this.texts[j].length();
                ++j;
            }
        }
    }

    private String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.texts = this.splitText(text);
        this.reanalyze = true;
    }

    public String[] splitText(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            boolean isSplit = false;
            int j = 0;
            while (j < this.splitchars.length) {
                if (ch == this.splitchars[j]) {
                    isSplit = true;
                    break;
                }
                ++j;
            }
            if (isSplit) {
                if (buffer.length() > 0) {
                    list.add(buffer.toString());
                    list.add("" + ch);
                    buffer = new StringBuffer();
                } else {
                    list.add("" + ch);
                }
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    public byte[] toCharByte(Graphics2D g2, String text) {
        byte[] bytes = new byte[text.length()];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = text.charAt(i) == '\n' ? (byte)0 : (byte)g2.getFontMetrics().stringWidth("" + text.charAt(i));
            ++i;
        }
        return bytes;
    }

    private int toWordLength(int index) {
        int start = 0;
        int i = 0;
        while (i < index) {
            if (i < this.texts.length) {
                start += this.texts[i].length();
            }
            ++i;
        }
        return this.toWordLength(start, this.texts[index].length());
    }

    private int toWordLength(int start, int length) {
        int result = 0;
        int i = start;
        while (i < start + length) {
            result += this.charWidths[i];
            ++i;
        }
        return result;
    }

    public int[] splitLine(Graphics2D g2) {
        ArrayList<Integer> returnList = new ArrayList<Integer>();
        int dx = 0;
        int dy = 0;
        this.stringHeight = g2.getFontMetrics().getHeight();
        int index = 0;
        int j = 0;
        while (j < this.texts.length) {
            if (!this.texts[j].equals("\n")) {
                int length = this.toWordLength(index, this.texts[j].length());
                if (this.wrap && dx + length > this.width) {
                    returnList.add(new Integer(j));
                    dx = 0;
                    dy += this.stringHeight;
                }
                dx += length;
            } else {
                dx = 0;
                dy += this.stringHeight;
                returnList.add(new Integer(j));
            }
            index += this.texts[j].length();
            ++j;
        }
        Integer[] integers = returnList.toArray(new Integer[returnList.size()]);
        int[] ret = new int[integers.length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = integers[i];
            ++i;
        }
        return ret;
    }

    public String getWord(int index) {
        return this.texts[index];
    }

    public int countWord() {
        return this.texts.length;
    }

    public boolean isReturn(int index) {
        int i = 0;
        while (i < this.returnPoint.length) {
            if (this.returnPoint[i] == index) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

