/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.effect;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.effect.VideoEffect;

public class FillColorEffect
extends VideoEffect {
    protected int fillColor;

    @Override
    public String toString() {
        String out = "FillColorEffect:color=" + this.fillColor + " " + super.toString();
        return out;
    }

    public FillColorEffect(int color) {
        this.fillColor = color;
    }

    public float getFrameTransparent(double t, double maxtime) {
        double time = Math.abs(t);
        if (time < this.fullEffectTime) {
            return 1.0f;
        }
        float value = 1.0f - Math.abs((float)((time - this.fullEffectTime) / (maxtime - this.fullEffectTime)));
        if (value > 1.0f) {
            log.warn((Object)("invalid: t=" + t + " max=" + maxtime + " v=" + value));
            return 1.0f;
        }
        log.info((Object)("t=" + t + " max=" + maxtime + " v=" + value));
        return value;
    }

    @Override
    public void effectAfter(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        g2.setColor(new Color(this.fillColor));
        g2.setComposite(AlphaComposite.getInstance(3, this.getFrameTransparent(time, this.getAfterTime())));
        g2.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
    }

    @Override
    public void effectAll(DougaPreference preference, BufferedImage baseImage, int frame) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        g2.setColor(new Color(this.fillColor));
        g2.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
    }

    @Override
    public void effectBefore(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        g2.setColor(new Color(this.fillColor));
        float f = this.getFrameTransparent(time, this.getBeforeTime());
        log.info((Object)("trans=" + f));
        g2.setComposite(AlphaComposite.getInstance(3, f));
        g2.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void effectKeyFrame(DougaPreference preference, BufferedImage baseImage, int frame, double time) throws IOException {
        Graphics2D g2 = (Graphics2D)baseImage.getGraphics();
        g2.setColor(new Color(this.fillColor));
        g2.fillRect(0, 0, baseImage.getWidth(), baseImage.getHeight());
    }
}

