/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.InputStreamFFMpegExecuter;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.audio.AudioInput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AudioUtils {
    public static final int NOT_SPECIFIED = -1;
    public static Log log = LogFactory.getLog(AudioUtils.class);

    public static InputStreamFFMpegExecuter createAudioFFMpegExecuter(String ffmpegPath, String inputFile, int rate, int channel) {
        InputStreamFFMpegExecuter executer = new InputStreamFFMpegExecuter();
        FFMpegPreference preference = new FFMpegPreference();
        preference.setFfmpegPath(ffmpegPath);
        preference.setAudioRate(rate);
        preference.setAudioChannel(channel);
        preference.setExtension("wav");
        return executer;
    }

    public static long copyAudio(String ffmpegPath, String input, double start, double duration, OutputStream output) throws IOException {
        int r;
        AudioInput audioInput = new AudioInput(ffmpegPath, input, start, duration);
        InputStream inputStream = audioInput.getInputStream();
        audioInput.startInput();
        long writed = 0L;
        byte[] bytes = new byte[1024];
        while ((r = inputStream.read(bytes)) != -1) {
            if (DougaSystem.cancelling) {
                log.info((Object)"dougasystem cancelled");
                break;
            }
            output.write(bytes, 0, r);
            writed += (long)r;
        }
        inputStream.close();
        return writed;
    }

    public static long loopAudio(String ffmpegPath, String input, double start, double duration, int looptime, double padtime, boolean cutInLoop, long maxbyte, OutputStream output) throws IOException {
        if (looptime == 0) {
            return 0L;
        }
        log.info((Object)("cutInLoop:" + cutInLoop));
        File tmp = File.createTempFile("loop", ".pcm");
        tmp.deleteOnExit();
        BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(tmp));
        AudioUtils.copyAudio(ffmpegPath, input, start, duration, bout);
        bout.close();
        int index = 0;
        long writed = 0L;
        boolean loop = true;
        block0: while (loop) {
            int w;
            BufferedInputStream binput = new BufferedInputStream(new FileInputStream(tmp));
            byte[] bts = new byte[1024];
            while ((w = binput.read(bts)) != -1) {
                if (DougaSystem.cancelling) {
                    log.info((Object)"dougasystem cancelled");
                    break block0;
                }
                if (maxbyte > 0L) {
                    if (writed + (long)w < maxbyte) {
                        output.write(bts, 0, w);
                        writed += (long)w;
                        continue;
                    }
                    int r = (int)(maxbyte - writed);
                    if (cutInLoop) {
                        output.write(bts, 0, r);
                        writed += (long)r;
                        binput.close();
                        break block0;
                    }
                    output.write(bts, 0, w);
                    writed += (long)w;
                    loop = false;
                    continue;
                }
                output.write(bts, 0, w);
                writed += (long)w;
            }
            binput.close();
            if (++index == looptime) {
                loop = false;
            }
            if (!loop || !(padtime > 0.0)) continue;
            writed += AudioUtils.writeZero(output, padtime, 48000, 2);
        }
        return writed;
    }

    public static long writeZero(OutputStream output, double time, int rate, int channel) throws IOException {
        long mustread = new BigDecimal("" + time).multiply(new BigDecimal(rate * channel * 2)).longValue();
        byte[] bts = new byte[1024];
        long writed = 0L;
        while (writed < mustread) {
            int w = writed + (long)bts.length < mustread ? bts.length : (int)(mustread - writed);
            output.write(bts, 0, w);
            writed += (long)w;
        }
        log.info((Object)("zero:" + writed));
        return writed;
    }

    public static void s16leToWav(File input, File output) throws IOException {
        long frames = input.length() / 4L;
        AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
        log.info((Object)("frames:" + frames));
        AudioInputStream ainput = new AudioInputStream(new BufferedInputStream(new FileInputStream(input)), format, frames);
        BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(output));
        long writtenBytes = AudioSystem.write(ainput, AudioFileFormat.Type.WAVE, fout);
        log.info((Object)("writed:" + writtenBytes));
        ((OutputStream)fout).close();
    }
}

