/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public class DecoratedShapePainter
implements Cloneable {
    private boolean antialiase = true;
    private boolean antialiaseShadow = true;
    private boolean fill = true;
    private boolean line = true;
    private int fillColor = 0xFFFFFF;
    private int lineColor = 0x333333;
    private int shadowColor = 0;
    private int lineSize = 2;
    private int shadowOffsetX = 2;
    private int shadowOffsetY = 2;
    private boolean shadow = false;
    private Shape selectionShape;
    private int selectColor = 32768;

    public DecoratedShapePainter clone() throws CloneNotSupportedException {
        return (DecoratedShapePainter)super.clone();
    }

    public BufferedImage createImage(Shape shape) {
        int width = shape.getBounds().width + (this.shadowOffsetX + this.lineSize) * 2;
        int height = shape.getBounds().height + (this.shadowOffsetY + this.lineSize) * 2;
        BufferedImage bimage = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)bimage.getGraphics();
        g2.translate(this.shadowOffsetX + this.lineSize, this.shadowOffsetY + this.lineSize);
        this.paint(g2, shape);
        return bimage;
    }

    public void paint(Graphics2D g2, Shape shape) {
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if (this.shadow) {
            if (this.antialiaseShadow) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g2.translate(this.shadowOffsetX, this.shadowOffsetY);
            g2.setStroke(new BasicStroke(this.lineSize));
            g2.setColor(new Color(this.shadowColor));
            g2.draw(shape);
            g2.fill(shape);
            g2.translate(-this.shadowOffsetX, -this.shadowOffsetY);
        }
        if (this.antialiase) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.line) {
            g2.setStroke(new BasicStroke(this.lineSize));
            g2.setColor(new Color(this.lineColor));
            g2.draw(shape);
        }
        if (this.fill) {
            g2.setColor(new Color(this.fillColor));
            g2.fill(shape);
        }
        if (this.selectionShape != null) {
            Graphics2D tmpG = (Graphics2D)g2.create();
            tmpG.clip(this.selectionShape);
            tmpG.setColor(new Color(this.selectColor));
            tmpG.fill(shape);
        }
    }

    public boolean isAntialiase() {
        return this.antialiase;
    }

    public void setAntialiase(boolean antialiase) {
        this.antialiase = antialiase;
    }

    public boolean isAntialiaseShadow() {
        return this.antialiaseShadow;
    }

    public void setAntialiaseShadow(boolean antialiaseShadow) {
        this.antialiaseShadow = antialiaseShadow;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
    }

    public boolean isLine() {
        return this.line;
    }

    public void setLine(boolean line) {
        this.line = line;
    }

    public int getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(int lineColor) {
        this.lineColor = lineColor;
    }

    public int getLineSize() {
        return this.lineSize;
    }

    public void setLineSize(int lineSize) {
        this.lineSize = lineSize;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.shadowColor = shadowColor;
    }

    public int getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public void setShadowOffsetX(int shadowOffsetX) {
        this.shadowOffsetX = shadowOffsetX;
    }

    public int getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public void setShadowOffsetY(int shadowOffsetY) {
        this.shadowOffsetY = shadowOffsetY;
    }

    public int getSelectColor() {
        return this.selectColor;
    }

    public void setSelectColor(int selectColor) {
        this.selectColor = selectColor;
    }

    public Shape getSelectionShape() {
        return this.selectionShape;
    }

    public void setSelectionShape(Shape selectionShape) {
        this.selectionShape = selectionShape;
    }
}

