/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.audio;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;
import com.jmex.audio.AudioSystem;

public abstract class Ear {
    public static float EAR_THROTTLE = 0.033f;
    private Vector3f position = new Vector3f();
    private Vector3f upVector = new Vector3f(0.0f, 0.0f, 1.0f);
    private Vector3f facingVector = new Vector3f(0.0f, -1.0f, 0.0f);
    private Vector3f currVelocity = new Vector3f();
    private EarTracker positionTracker = null;
    private EarTracker orientTracker = null;
    float elapsed = 0.0f;

    public Vector3f getCurrVelocity() {
        return this.currVelocity;
    }

    public void setCurrVelocity(Vector3f vector3f) {
        this.currVelocity.set(vector3f);
    }

    public Vector3f getFacingVector() {
        return this.facingVector;
    }

    public void setFacingVector(Vector3f vector3f) {
        this.facingVector.set(vector3f);
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f vector3f) {
        this.position.set(vector3f);
    }

    public Vector3f getUpVector() {
        return this.upVector;
    }

    public void setUpVector(Vector3f vector3f) {
        this.upVector.set(vector3f);
    }

    public void trackPosition(Camera camera) {
        this.positionTracker = new EarTracker(camera);
        this.update(1.0f);
    }

    public void trackPosition(Spatial spatial) {
        this.positionTracker = new EarTracker(spatial);
        this.update(1.0f);
    }

    public void trackOrientation(Camera camera) {
        this.orientTracker = new EarTracker(camera);
        this.update(1.0f);
    }

    public void trackOrientation(Spatial spatial) {
        this.orientTracker = new EarTracker(spatial);
        this.update(1.0f);
    }

    public void update(float f) {
        this.elapsed += f;
        if (this.elapsed < EAR_THROTTLE) {
            return;
        }
        if (this.positionTracker != null) {
            this.positionTracker.applyPosition(this.getPosition(), this.getCurrVelocity(), this.elapsed);
        }
        if (this.orientTracker != null) {
            this.orientTracker.applyOrientation(this.getUpVector(), this.getFacingVector());
        }
        this.elapsed = 0.0f;
    }

    class EarTracker {
        public Camera trackedCamera = null;
        public Spatial trackedSpatial = null;
        private Vector3f lastPosition = new Vector3f();

        public EarTracker(Camera camera) {
            this.trackedCamera = camera;
            this.lastPosition.set(camera.getLocation());
        }

        public EarTracker(Spatial spatial) {
            this.trackedSpatial = spatial;
            this.lastPosition.set(spatial.getWorldTranslation());
        }

        public void applyPosition(Vector3f vector3f, Vector3f vector3f2, float f) {
            this.lastPosition.set(vector3f);
            if (this.trackedCamera != null) {
                vector3f.set(this.trackedCamera.getLocation());
            } else {
                vector3f.set(this.trackedSpatial.getWorldTranslation());
            }
            if (vector3f2 != null) {
                vector3f2.set(vector3f).subtractLocal(this.lastPosition).divideLocal(f * AudioSystem.getSystem().getUnitsPerMeter());
                if (vector3f2.lengthSquared() > 2500.0f) {
                    vector3f2.normalizeLocal();
                    vector3f2.multLocal(50.0f);
                }
            }
        }

        public void applyOrientation(Vector3f vector3f, Vector3f vector3f2) {
            if (this.trackedCamera != null) {
                vector3f.set(this.trackedCamera.getUp());
                vector3f2.set(this.trackedCamera.getDirection());
            } else {
                Quaternion quaternion = this.trackedSpatial.getWorldRotation();
                quaternion.getRotationColumn(1, vector3f);
                quaternion.getRotationColumn(2, vector3f2);
            }
        }
    }
}

