/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.effects.particles;

import com.jme.intersection.CollisionResults;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Geometry;
import com.jme.scene.Spatial;
import com.jme.scene.batch.PointBatch;
import com.jme.util.geom.BufferUtils;
import com.jmex.effects.particles.Particle;
import com.jmex.effects.particles.ParticleGeometry;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class ParticlePoints
extends ParticleGeometry {
    private static final long serialVersionUID = 2L;

    public ParticlePoints() {
    }

    public ParticlePoints(String string, int n) {
        super(string, n);
    }

    protected void initializeParticles(int n) {
        int n2;
        Vector2f[] vector2fArray = new Vector2f[]{new Vector2f(0.0f, 0.0f)};
        int n3 = ParticlePoints.getVertsForParticleType(this.getParticleType());
        this.geometryCoordinates = BufferUtils.createVector3Buffer((int)(n * n3));
        int[] nArray = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n2;
        }
        this.appearanceColors = BufferUtils.createColorBuffer((int)(n * n3));
        this.particles = new Particle[n];
        this.setVertexBuffer(0, this.geometryCoordinates);
        this.setColorBuffer(0, this.appearanceColors);
        this.setTextureBuffer(0, BufferUtils.createVector2Buffer((int)(n * n3)));
        this.getBatch(0).setIndexBuffer(BufferUtils.createIntBuffer((int[])nArray));
        this.setRenderQueueMode(2);
        this.setLightCombineMode(0);
        this.setTextureCombineMode(5);
        this.invScale = new Vector3f();
        for (n2 = 0; n2 < n; ++n2) {
            this.particles[n2] = new Particle(this);
            this.particles[n2].init();
            this.particles[n2].setStartIndex(n2 * n3);
            for (int i = n3 - 1; i >= 0; --i) {
                int n4 = n2 * n3 + i;
                BufferUtils.setInBuffer((Vector2f)vector2fArray[i], (FloatBuffer)this.getTextureBuffer(0, 0), (int)n4);
                BufferUtils.setInBuffer((ColorRGBA)this.particles[n2].getCurrentColor(), (FloatBuffer)this.appearanceColors, (int)n4);
            }
        }
    }

    public int getParticleType() {
        return 2;
    }

    public void draw(Renderer renderer) {
        PointBatch pointBatch;
        Camera camera = renderer.getCamera();
        for (int i = 0; i < this.particles.length; ++i) {
            Particle particle = this.particles[i];
            if (particle.getStatus() != 1) continue;
            particle.updateVerts(camera);
        }
        if (this.getBatchCount() == 1 && (pointBatch = this.getBatch(0)) != null && pointBatch.isEnabled()) {
            pointBatch.setLastFrustumIntersection(this.frustrumIntersects);
            pointBatch.draw(renderer);
            return;
        }
        int n = this.getBatchCount();
        for (int i = 0; i < n; ++i) {
            PointBatch pointBatch2 = this.getBatch(i);
            if (pointBatch2 == null || !pointBatch2.isEnabled()) continue;
            pointBatch2.onDraw(renderer);
        }
    }

    protected void setupBatchList() {
        this.batchList = new ArrayList(1);
        PointBatch pointBatch = new PointBatch();
        pointBatch.setParentGeom((Geometry)this);
        this.batchList.add(pointBatch);
    }

    public PointBatch getBatch(int n) {
        return (PointBatch)this.batchList.get(n);
    }

    public boolean isAntialiased() {
        return this.getBatch(0).isAntialiased();
    }

    public void setAntialiased(boolean bl) {
        this.getBatch(0).setAntialiased(bl);
    }

    public float getPointSize() {
        return this.getBatch(0).getPointSize();
    }

    public void setPointSize(float f) {
        this.getBatch(0).setPointSize(f);
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        return false;
    }
}

