/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.XMLparser;

import com.jme.animation.SpatialTransformer;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.JointMesh;
import com.jmex.model.XMLparser.LoaderNode;
import com.jmex.model.XMLparser.XMLloadable;
import com.jmex.model.animation.JointController;
import com.jmex.model.animation.KeyframeController;
import com.jmex.model.animation.PointInTime;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.TerrainPage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;

public class JmeBinaryWriter {
    private DataOutputStream myOut;
    private static final boolean DEBUG = false;
    private IdentityHashMap<Object, String> sharedObjects = new IdentityHashMap(20);
    private IdentityHashMap<Object, String> entireScene = new IdentityHashMap(256);
    private static final Quaternion DEFAULT_ROTATION = new Quaternion();
    private static final Vector3f DEFAULT_TRANSLATION = new Vector3f();
    private static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
    private HashMap<String, Object> properties = new HashMap();
    private int totalShared = 0;

    public void writeScene(Node scene, OutputStream bin) throws IOException {
        this.myOut = new DataOutputStream(bin);
        this.sharedObjects.clear();
        this.entireScene.clear();
        this.totalShared = 0;
        this.writeHeader();
        this.findDuplicates((Spatial)scene);
        this.entireScene.clear();
        this.writeSpatial((Spatial)scene);
        this.writeClosing();
        this.myOut.close();
    }

    private void findDuplicates(Spatial n) {
        if (n == null) {
            return;
        }
        if (this.entireScene.containsKey(n)) {
            if (!this.sharedObjects.containsKey(n)) {
                this.sharedObjects.put(n, "sharedSpatial" + this.totalShared++);
            }
            return;
        }
        this.entireScene.put(n, null);
        this.evaluateSpatialChildrenDuplicates(n);
        if ((n.getType() & 1) == 0) {
            return;
        }
        Node temp = (Node)n;
        for (int i = temp.getQuantity() - 1; i >= 0; --i) {
            this.findDuplicates(temp.getChild(i));
        }
    }

    public void writeScene(Spatial spatial, OutputStream jMEFormat) throws IOException {
        if (spatial instanceof Node) {
            this.writeScene((Node)spatial, jMEFormat);
        } else if (spatial instanceof Geometry) {
            this.writeScene((Geometry)spatial, jMEFormat);
        }
    }

    private void evaluateSpatialChildrenDuplicates(Spatial s) {
        int i;
        if (s == null) {
            return;
        }
        for (i = 0; i < s.getControllers().size(); ++i) {
            Controller evaluCont = s.getController(i);
            if (evaluCont == null) continue;
            if (this.entireScene.containsKey(evaluCont)) {
                if (this.sharedObjects.containsKey(evaluCont)) continue;
                this.sharedObjects.put(evaluCont, "sharedController" + this.totalShared++);
                continue;
            }
            this.entireScene.put(evaluCont, null);
            if (!(evaluCont instanceof SpatialTransformer)) continue;
            for (int j = 0; j < ((SpatialTransformer)evaluCont).toChange.length; ++j) {
                this.findDuplicateObjects(((SpatialTransformer)evaluCont).toChange[j]);
            }
        }
        for (i = 0; i < 17; ++i) {
            RenderState evaluRend = s.getRenderState(i);
            if (evaluRend == null) continue;
            if (this.entireScene.containsKey(evaluRend)) {
                if (this.sharedObjects.containsKey(evaluRend)) continue;
                this.sharedObjects.put(evaluRend, "sharedRenderState" + this.totalShared++);
                continue;
            }
            this.entireScene.put(evaluRend, null);
        }
    }

    private void findDuplicateObjects(Object n) {
        if (n instanceof Spatial) {
            this.findDuplicates((Spatial)n);
        }
    }

    public void writeScene(Geometry geo, OutputStream bin) throws IOException {
        this.totalShared = 0;
        this.myOut = new DataOutputStream(bin);
        this.sharedObjects.clear();
        this.entireScene.clear();
        this.writeHeader();
        this.findDuplicates((Spatial)geo);
        this.entireScene.clear();
        this.writeSpatial((Spatial)geo);
        this.writeClosing();
        this.myOut.close();
    }

    private void writeNode(Node node) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(node)) {
            atts.put("sharedident", this.sharedObjects.get(node));
        }
        this.putSpatialAtts((Spatial)node, atts);
        this.writeTag("node", atts);
        this.writeChildren(node);
        this.writeSpatialChildren((Spatial)node);
        this.writeEndTag("node");
    }

    private void writeTerrainPage(TerrainPage terrainPage) throws IOException {
        if (terrainPage == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(terrainPage)) {
            atts.put("sharedident", this.sharedObjects.get(terrainPage));
        }
        this.putSpatialAtts((Spatial)terrainPage, atts);
        atts.put("offset", terrainPage.getOffset());
        atts.put("totsize", new Integer(terrainPage.getTotalSize()));
        atts.put("size", new Integer(terrainPage.getSize()));
        atts.put("stepscale", terrainPage.getStepScale());
        atts.put("offamnt", new Float(terrainPage.getOffsetAmount()));
        this.writeTag("terrainpage", atts);
        this.writeChildren((Node)terrainPage);
        this.writeSpatialChildren((Spatial)terrainPage);
        this.writeEndTag("terrainpage");
    }

    private void writeSharedObject(Object o) throws IOException {
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.clear();
        atts.put("ident", this.sharedObjects.get(o));
        this.writeTag("repeatobject", atts);
        this.writeEndTag("repeatobject");
    }

    private void writeChildren(Node node) throws IOException {
        for (int i = 0; i < node.getQuantity(); ++i) {
            this.writeSpatial(node.getChild(i));
        }
    }

    private void writeSpatial(Spatial s) throws IOException {
        if (this.sharedObjects.containsKey(s)) {
            if (this.entireScene.containsKey(s)) {
                this.writeSharedObject(s);
                return;
            }
            this.entireScene.put(s, null);
        }
        if (s instanceof XMLloadable) {
            this.writeXMLloadable((XMLloadable)s);
        } else if (s instanceof LoaderNode) {
            this.writeLoaderNode((LoaderNode)s);
        } else if (s instanceof JointMesh) {
            this.writeJointMesh((JointMesh)s);
        } else if (s instanceof TerrainPage) {
            this.writeTerrainPage((TerrainPage)s);
        } else if (s instanceof Node) {
            this.writeNode((Node)s);
        } else if (s instanceof TerrainBlock) {
            this.writeTerrainBlock((TerrainBlock)s);
        } else if (s instanceof AreaClodMesh) {
            this.writeAreaClod((AreaClodMesh)s);
        } else if (s instanceof ClodMesh) {
            this.writeClod((ClodMesh)s);
        } else if (s instanceof TriMesh) {
            this.writeMesh((TriMesh)s);
        }
    }

    private void writeLoaderNode(LoaderNode loaderNode) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey((Object)loaderNode)) {
            atts.put("sharedident", this.sharedObjects.get((Object)loaderNode));
        }
        atts.put("type", loaderNode.type);
        if (loaderNode.filePath != null) {
            atts.put("file", loaderNode.filePath);
        } else if (loaderNode.urlPath != null) {
            atts.put("url", loaderNode.urlPath);
        } else if (loaderNode.classLoaderPath != null) {
            atts.put("classloader", loaderNode.classLoaderPath);
        }
        this.writeTag("jmefile", atts);
        this.writeEndTag("jmefile");
    }

    private void writeTerrainBlock(TerrainBlock terrainBlock) throws IOException {
        if (terrainBlock == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(terrainBlock)) {
            atts.put("sharedident", this.sharedObjects.get(terrainBlock));
        }
        this.putSpatialAtts((Spatial)terrainBlock, atts);
        atts.put("trisppix", new Float(terrainBlock.getTrisPerPixel()));
        atts.put("disttol", new Float(terrainBlock.getDistanceTolerance()));
        atts.put("tbsize", new Integer(terrainBlock.getSize()));
        atts.put("totsize", new Integer(terrainBlock.getTotalSize()));
        atts.put("step", terrainBlock.getStepScale());
        atts.put("isclod", new Boolean(terrainBlock.isUseClod()));
        atts.put("offset", terrainBlock.getOffset());
        atts.put("offamnt", new Float(terrainBlock.getOffsetAmount()));
        atts.put("hmap", terrainBlock.getHeightMap());
        this.writeTag("terrainblock", atts);
        this.writeTriMeshTags((TriMesh)terrainBlock);
        this.writeRecords(terrainBlock.getRecords());
        this.writeSpatialChildren((Spatial)terrainBlock);
        this.writeEndTag("terrainblock");
    }

    private void writeAreaClod(AreaClodMesh areaClodMesh) throws IOException {
        if (areaClodMesh == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(areaClodMesh)) {
            atts.put("sharedident", this.sharedObjects.get(areaClodMesh));
        }
        this.putSpatialAtts((Spatial)areaClodMesh, atts);
        atts.put("trisppix", new Float(areaClodMesh.getTrisPerPixel()));
        atts.put("disttol", new Float(areaClodMesh.getDistanceTolerance()));
        this.writeTag("areaclod", atts);
        this.writeTriMeshTags((TriMesh)areaClodMesh);
        this.writeRecords(areaClodMesh.getRecords());
        this.writeSpatialChildren((Spatial)areaClodMesh);
        this.writeEndTag("areaclod");
    }

    private void writeClod(ClodMesh clodMesh) throws IOException {
        if (clodMesh == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(clodMesh)) {
            atts.put("sharedident", this.sharedObjects.get(clodMesh));
        }
        this.putSpatialAtts((Spatial)clodMesh, atts);
        this.writeTag("clod", atts);
        this.writeTriMeshTags((TriMesh)clodMesh);
        this.writeRecords(clodMesh.getRecords());
        this.writeSpatialChildren((Spatial)clodMesh);
        this.writeEndTag("clod");
    }

    private void writeRecords(CollapseRecord[] records) throws IOException {
        if (records == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        atts.put("numrec", new Integer(records.length));
        this.writeTag("clodrecords", atts);
        for (int i = 0; i < records.length; ++i) {
            atts.clear();
            atts.put("index", new Integer(i));
            atts.put("numi", new Integer(records[i].numbIndices));
            atts.put("numt", new Integer(records[i].numbTriangles));
            atts.put("numv", new Integer(records[i].numbVerts));
            atts.put("vkeep", new Integer(records[i].vertToKeep));
            atts.put("vthrow", new Integer(records[i].vertToThrow));
            if (records[i].indices != null) {
                atts.put("indexary", records[i].indices);
            }
            this.writeTag("crecord", atts);
            this.writeEndTag("crecord");
        }
        this.writeEndTag("clodrecords");
    }

    private void writeMesh(TriMesh triMesh) throws IOException {
        if (triMesh == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(triMesh)) {
            atts.put("sharedident", this.sharedObjects.get(triMesh));
        }
        this.putSpatialAtts((Spatial)triMesh, atts);
        this.writeTag("mesh", atts);
        if (triMesh.getBatchCount() == 1) {
            this.writeTriMeshTags(triMesh);
        } else {
            for (int i = 0; i < triMesh.getBatchCount(); ++i) {
                this.writeTag("batch" + i, atts);
                this.writeTriMeshTags(triMesh);
                for (int j = 0; j < 17; ++j) {
                    if (triMesh.getBatch(i).getRenderState(j) == null) continue;
                    this.writeRenderState(triMesh.getBatch(i).getRenderState(j));
                }
                this.writeEndTag("batch" + i);
            }
        }
        this.writeSpatialChildren((Spatial)triMesh);
        this.writeEndTag("mesh");
    }

    private void writeJointMesh(JointMesh jointMesh) throws IOException {
        int i;
        if ("astrimesh".equals(this.properties.get("jointmesh"))) {
            this.writeMesh((TriMesh)jointMesh);
            return;
        }
        for (i = 0; i < jointMesh.jointIndex.length && jointMesh.jointIndex[i] == -1; ++i) {
        }
        if (i == jointMesh.jointIndex.length) {
            this.writeMesh((TriMesh)jointMesh);
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(jointMesh)) {
            atts.put("sharedident", this.sharedObjects.get(jointMesh));
        }
        this.putSpatialAtts((Spatial)jointMesh, atts);
        this.writeTag("jointmesh", atts);
        this.writeJointMeshTags(jointMesh);
        this.writeSpatialChildren((Spatial)jointMesh);
        this.writeEndTag("jointmesh");
    }

    private void writeJointMeshTags(JointMesh jointMesh) throws IOException {
        HashMap<String, Object[]> atts = new HashMap<String, Object[]>();
        atts.clear();
        atts.put("data", jointMesh.jointIndex);
        this.writeTag("jointindex", atts);
        this.writeEndTag("jointindex");
        atts.clear();
        atts.put("data", jointMesh.originalVertex);
        this.writeTag("origvertex", atts);
        this.writeEndTag("origvertex");
        atts.clear();
        atts.put("data", jointMesh.originalNormal);
        this.writeTag("orignormal", atts);
        this.writeEndTag("orignormal");
        this.writeTriMeshTags((TriMesh)jointMesh);
    }

    private void writeXMLloadable(XMLloadable xmlloadable) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (this.sharedObjects.containsKey(xmlloadable)) {
            atts.put("sharedident", this.sharedObjects.get(xmlloadable));
        }
        atts.put("class", xmlloadable.getClass().getName());
        if (xmlloadable instanceof Spatial) {
            this.putSpatialAtts((Spatial)xmlloadable, atts);
        }
        atts.put("args", xmlloadable.writeToXML());
        this.writeTag("xmlloadable", atts);
        if (xmlloadable instanceof Spatial) {
            this.writeSpatialChildren((Spatial)xmlloadable);
        }
        if (xmlloadable instanceof Node) {
            this.writeChildren((Node)xmlloadable);
        }
        this.writeEndTag("xmlloadable");
    }

    private void writeSpatialChildren(Spatial spatial) throws IOException {
        this.writeRenderStates(spatial);
        this.writeControllers(spatial);
    }

    private void writeControllers(Spatial spatial) throws IOException {
        ArrayList conts = spatial.getControllers();
        if (conts == null) {
            return;
        }
        for (int i = 0; i < conts.size(); ++i) {
            Controller r = (Controller)conts.get(i);
            if (this.sharedObjects.containsKey(r)) {
                if (this.entireScene.containsKey(r)) {
                    this.writeSharedObject(r);
                    return;
                }
                this.entireScene.put(r, null);
            }
            if (r instanceof JointController) {
                this.writeJointController((JointController)r);
                continue;
            }
            if (r instanceof SpatialTransformer) {
                this.writeSpatialTransformer((SpatialTransformer)r);
                continue;
            }
            if (r instanceof KeyframeController) {
                this.writeKeyframeController((KeyframeController)r);
                continue;
            }
            if (!(r instanceof XMLloadable)) continue;
            this.writeXMLloadable((XMLloadable)r);
        }
    }

    private void addControllerBaseAtts(Controller c, HashMap<String, Object> atts) {
        atts.put("rptype", new Integer(c.getRepeatType()));
        atts.put("speed", new Float(c.getSpeed()));
    }

    private void writeSpatialTransformer(SpatialTransformer st) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(st)) {
            atts.put("sharedident", this.sharedObjects.get(st));
        }
        atts.put("numobjects", new Integer(st.getNumObjects()));
        this.writeTag("spatialtransformer", atts);
        for (int i = 0; i < st.toChange.length; ++i) {
            atts.clear();
            atts.put("obnum", new Integer(i));
            atts.put("parnum", new Integer(st.parentIndexes[i]));
            this.writeTag("stobj", atts);
            this.writeObject(st.toChange[i]);
            this.writeEndTag("stobj");
        }
        ArrayList keyframes = st.keyframes;
        for (int i = 0; i < keyframes.size(); ++i) {
            this.writeSpatialTransformerPointInTime((SpatialTransformer.PointInTime)keyframes.get(i));
        }
        this.writeEndTag("spatialtransformer");
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof Spatial) {
            this.writeSpatial((Spatial)o);
        }
    }

    private void writeSpatialTransformerPointInTime(SpatialTransformer.PointInTime pointInTime) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        atts.put("time", new Float(pointInTime.time));
        this.writeTag("spatialpointtime", atts);
        BitSet thisSet = pointInTime.usedScale;
        int[] setScales = new int[thisSet.cardinality()];
        Vector3f[] scaleValues = new Vector3f[thisSet.cardinality()];
        int i = thisSet.nextSetBit(0);
        int j = 0;
        while (i >= 0) {
            setScales[j] = i;
            scaleValues[j] = new Vector3f();
            pointInTime.look[i].getScale(scaleValues[j]);
            i = thisSet.nextSetBit(i + 1);
            ++j;
        }
        atts.clear();
        atts.put("index", setScales);
        atts.put("scalevalues", scaleValues);
        this.writeTag("sptscale", atts);
        this.writeEndTag("sptscale");
        thisSet = pointInTime.usedRot;
        int[] setRots = new int[thisSet.cardinality()];
        Quaternion[] rotValues = new Quaternion[thisSet.cardinality()];
        int i2 = thisSet.nextSetBit(0);
        int j2 = 0;
        while (i2 >= 0) {
            setRots[j2] = i2;
            rotValues[j2] = new Quaternion();
            pointInTime.look[i2].getRotation(rotValues[j2]);
            i2 = thisSet.nextSetBit(i2 + 1);
            ++j2;
        }
        atts.clear();
        atts.put("index", setRots);
        atts.put("rotvalues", rotValues);
        this.writeTag("sptrot", atts);
        this.writeEndTag("sptrot");
        thisSet = pointInTime.usedTrans;
        int[] setTrans = new int[thisSet.cardinality()];
        Vector3f[] transValues = new Vector3f[thisSet.cardinality()];
        int i3 = thisSet.nextSetBit(0);
        int j3 = 0;
        while (i3 >= 0) {
            setTrans[j3] = i3;
            transValues[j3] = new Vector3f();
            pointInTime.look[i3].getTranslation(transValues[j3]);
            i3 = thisSet.nextSetBit(i3 + 1);
            ++j3;
        }
        atts.clear();
        atts.put("index", setTrans);
        atts.put("transvalues", transValues);
        this.writeTag("spttrans", atts);
        this.writeEndTag("spttrans");
        this.writeEndTag("spatialpointtime");
    }

    private void writeKeyframeController(KeyframeController kc) throws IOException {
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.clear();
        if (this.sharedObjects.containsKey(kc)) {
            atts.put("sharedident", this.sharedObjects.get(kc));
        }
        this.writeTag("keyframecontroller", atts);
        ArrayList keyframes = kc.keyframes;
        for (int i = 0; i < keyframes.size(); ++i) {
            this.writeKeyFramePointInTime((KeyframeController.PointInTime)keyframes.get(i));
        }
        this.writeEndTag("keyframecontroller");
    }

    private void writeKeyFramePointInTime(KeyframeController.PointInTime pointInTime) throws IOException {
        HashMap<String, Float> atts = new HashMap<String, Float>();
        atts.clear();
        atts.put("time", new Float(pointInTime.time));
        this.writeTag("keyframepointintime", atts);
        this.writeTriMeshTags(pointInTime.newShape);
        this.writeEndTag("keyframepointintime");
    }

    private void writeTriMeshTags(TriMesh triMesh) throws IOException {
        if (triMesh == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (triMesh.getVertexBuffer(0) != null) {
            if (this.properties.get("q3vert") != null) {
                atts.put("q3vert", this.vertsToShorts(BufferUtils.getVector3Array((FloatBuffer)triMesh.getVertexBuffer(0))));
            } else {
                atts.put("data", BufferUtils.getVector3Array((FloatBuffer)triMesh.getVertexBuffer(0)));
            }
        }
        this.writeTag("vertex", atts);
        this.writeEndTag("vertex");
        atts.clear();
        if (triMesh.getNormalBuffer(0) != null) {
            if (this.properties.get("q3norm") != null) {
                atts.put("q3norm", this.normsToShorts(BufferUtils.getVector3Array((FloatBuffer)triMesh.getNormalBuffer(0))));
            } else {
                atts.put("data", BufferUtils.getVector3Array((FloatBuffer)triMesh.getNormalBuffer(0)));
            }
        }
        this.writeTag("normal", atts);
        this.writeEndTag("normal");
        atts.clear();
        if (triMesh.getColorBuffer(0) != null) {
            atts.put("data", BufferUtils.getColorArray((FloatBuffer)triMesh.getColorBuffer(0)));
        }
        this.writeTag("color", atts);
        this.writeEndTag("color");
        atts.clear();
        for (int i = 0; i < triMesh.getNumberOfUnits(0); ++i) {
            if (triMesh.getTextureBuffer(0, i) == null) continue;
            if (i != 0) {
                atts.put("texindex", new Integer(i));
            }
            atts.put("data", BufferUtils.getVector2Array((FloatBuffer)triMesh.getTextureBuffer(0, i)));
            this.writeTag("texturecoords", atts);
            this.writeEndTag("texturecoords");
        }
        atts.clear();
        if (triMesh.getIndexBuffer(0) != null) {
            atts.put("data", BufferUtils.getIntArray((IntBuffer)triMesh.getIndexBuffer(0)));
        }
        this.writeTag("index", atts);
        this.writeEndTag("index");
        if (triMesh.getBatch(0).getModelBound() != null) {
            this.writeBounds(triMesh.getBatch(0).getModelBound());
        }
    }

    private void writeBounds(BoundingVolume bound) throws IOException {
        if (bound == null) {
            return;
        }
        if (bound instanceof BoundingBox) {
            this.writeBoundingBox((BoundingBox)bound);
        } else if (bound instanceof BoundingSphere) {
            this.writeBoundingSphere((BoundingSphere)bound);
        } else if (bound instanceof OrientedBoundingBox) {
            this.writeOBB((OrientedBoundingBox)bound);
        }
    }

    private void writeOBB(OrientedBoundingBox v) throws IOException {
        if (v == null) {
            return;
        }
        HashMap<String, String> atts = new HashMap<String, String>();
        if (this.sharedObjects.containsKey(v)) {
            atts.put("sharedident", this.sharedObjects.get(v));
        }
        atts.put("center", (String)v.getCenter());
        atts.put("xaxis", (String)v.getXAxis());
        atts.put("yaxis", (String)v.getYAxis());
        atts.put("zaxis", (String)v.getZAxis());
        atts.put("extent", (String)v.getExtent());
        this.writeTag("obb", atts);
        this.writeEndTag("obb");
    }

    private void writeBoundingSphere(BoundingSphere v) throws IOException {
        if (v == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (this.sharedObjects.containsKey(v)) {
            atts.put("sharedident", this.sharedObjects.get(v));
        }
        atts.put("center", v.getCenter());
        atts.put("radius", new Float(v.getRadius()));
        this.writeTag("boundsphere", atts);
        this.writeEndTag("boundsphere");
    }

    private void writeBoundingBox(BoundingBox v) throws IOException {
        if (v == null) {
            return;
        }
        HashMap<String, String> atts = new HashMap<String, String>();
        if (this.sharedObjects.containsKey(v)) {
            atts.put("sharedident", this.sharedObjects.get(v));
        }
        atts.put("nowcent", (String)v.getCenter());
        atts.put("nowext", (String)new Vector3f(v.xExtent, v.yExtent, v.zExtent));
        this.writeTag("boundbox", atts);
        this.writeEndTag("boundbox");
    }

    private short[] vertsToShorts(Vector3f[] vertices) {
        short[] parts = new short[vertices.length * 3];
        for (int i = 0; i < vertices.length; ++i) {
            parts[i * 3 + 0] = (short)(vertices[i].x / 0.015625f);
            parts[i * 3 + 1] = (short)(vertices[i].y / 0.015625f);
            parts[i * 3 + 2] = (short)(vertices[i].z / 0.015625f);
        }
        return parts;
    }

    private byte[] normsToShorts(Vector3f[] normals) {
        byte[] parts = new byte[normals.length * 2];
        for (int i = 0; i < parts.length; i += 2) {
            parts[i] = (byte)(57.295776f * FastMath.acos((float)normals[i / 2].z));
            parts[i + 1] = (byte)((float)Math.PI / 180 * FastMath.atan((float)(normals[i / 2].y / normals[i / 2].x)));
        }
        return parts;
    }

    private void writeJointController(JointController jc) throws IOException {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(jc)) {
            atts.put("sharedident", this.sharedObjects.get(jc));
        }
        atts.put("numJoints", new Integer(jc.numJoints));
        atts.put("fps", new Float(jc.FPS));
        this.addControllerBaseAtts((Controller)jc, atts);
        this.writeTag("jointcontroller", atts);
        Object[] o = jc.movementInfo.toArray();
        Vector3f tempV = new Vector3f();
        Matrix3f tempM = new Matrix3f();
        for (int j = 0; j < jc.numJoints; ++j) {
            atts.clear();
            atts.put("index", new Integer(j));
            atts.put("parentindex", new Integer(jc.parentIndex[j]));
            jc.localRefMatrix[j].getRotation(tempM);
            jc.localRefMatrix[j].getTranslation(tempV);
            atts.put("localrot", tempM);
            atts.put("localvec", tempV);
            this.writeTag("joint", atts);
            for (int i = 0; i < o.length; ++i) {
                PointInTime jp = (PointInTime)o[i];
                if (!jp.usedTrans.get(j) && !jp.usedRot.get(j)) continue;
                atts.clear();
                atts.put("time", new Float(jp.time));
                if (jp.usedTrans.get(j)) {
                    atts.put("trans", jp.jointTranslation[j]);
                }
                if (jp.usedRot.get(j)) {
                    atts.put("rot", jp.jointRotation[j]);
                }
                this.writeTag("keyframe", atts);
                this.writeEndTag("keyframe");
            }
            this.writeEndTag("joint");
        }
        this.writeEndTag("jointcontroller");
    }

    private void writeRenderStates(Spatial spatial) throws IOException {
        for (int i = 0; i < 17; ++i) {
            this.writeRenderState(spatial.getRenderState(i));
        }
    }

    private void writeRenderState(RenderState renderState) throws IOException {
        if (renderState == null) {
            return;
        }
        if (this.sharedObjects.containsKey(renderState)) {
            if (this.entireScene.containsKey(renderState)) {
                this.writeSharedObject(renderState);
                return;
            }
            this.entireScene.put(renderState, null);
        }
        if (renderState instanceof MaterialState) {
            this.writeMaterialState((MaterialState)renderState);
        } else if (renderState instanceof AlphaState) {
            this.writeAlphaState((AlphaState)renderState);
        } else if (renderState instanceof TextureState) {
            this.writeTextureState((TextureState)renderState);
        } else if (renderState instanceof LightState) {
            this.writeLightState((LightState)renderState);
        } else if (renderState instanceof CullState) {
            this.writeCullState((CullState)renderState);
        } else if (renderState instanceof WireframeState) {
            this.writeWireframeState((WireframeState)renderState);
        } else {
            System.out.println("Unknown render state... ut ow!");
        }
    }

    private void writeWireframeState(WireframeState wireframeState) throws IOException {
        if (wireframeState == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(wireframeState)) {
            atts.put("sharedident", this.sharedObjects.get(wireframeState));
        }
        atts.put("width", new Float(wireframeState.getLineWidth()));
        atts.put("facetype", new Integer(wireframeState.getFace()));
        this.writeTag("wirestate", atts);
        this.writeEndTag("wirestate");
    }

    private void writeCullState(CullState cullState) throws IOException {
        int i;
        if (cullState == null) {
            return;
        }
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.clear();
        if (this.sharedObjects.containsKey(cullState)) {
            atts.put("sharedident", this.sharedObjects.get(cullState));
        }
        if ((i = cullState.getCullMode()) == 2) {
            atts.put("cull", "back");
        } else if (i == 1) {
            atts.put("cull", "front");
        } else if (i == 0) {
            atts.put("cull", "none");
        }
        this.writeTag("cullstate", atts);
        this.writeEndTag("cullstate");
    }

    private void writeLightState(LightState lightState) throws IOException {
        if (lightState == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        atts.put("ambient", lightState.getGlobalAmbient());
        atts.put("twosided", lightState.getTwoSidedLighting());
        atts.put("local", lightState.getLocalViewer());
        atts.put("sepspec", lightState.getSeparateSpecular());
        if (this.sharedObjects.containsKey(lightState)) {
            atts.put("sharedident", this.sharedObjects.get(lightState));
        }
        this.writeTag("lightstate", null);
        for (int i = 0; i < lightState.getQuantity(); ++i) {
            atts.clear();
            Light thisChild = lightState.get(i);
            this.putLightProperties(thisChild, atts);
            if (thisChild.getType() == 2) {
                this.writeSpotLight((SpotLight)thisChild, atts);
                continue;
            }
            if (thisChild.getType() != 1) continue;
            this.writePointLight((PointLight)thisChild, atts);
        }
        this.writeEndTag("lightstate");
    }

    private void writePointLight(PointLight pointLight, HashMap<String, Object> atts) throws IOException {
        atts.put("loc", pointLight.getLocation());
        this.writeTag("pointlight", atts);
        this.writeEndTag("pointlight");
    }

    private void putLightProperties(Light child, HashMap<String, Object> atts) {
        atts.put("ambient", child.getAmbient());
        atts.put("fconstant", new Float(child.getConstant()));
        atts.put("diffuse", child.getDiffuse());
        atts.put("flinear", new Float(child.getLinear()));
        atts.put("fquadratic", new Float(child.getQuadratic()));
        atts.put("specular", child.getSpecular());
        atts.put("isattenuate", new Boolean(child.isAttenuate()));
    }

    private void writeSpotLight(SpotLight spotLight, HashMap<String, Object> atts) throws IOException {
        atts.put("loc", spotLight.getLocation());
        atts.put("fangle", new Float(spotLight.getAngle()));
        atts.put("dir", spotLight.getDirection());
        atts.put("fexponent", new Float(spotLight.getExponent()));
        this.writeTag("spotlight", atts);
        this.writeEndTag("spotlight");
    }

    private void writeTextureState(TextureState state) throws IOException {
        this.writeTag("texturestate", null);
        for (int i = 0; i < TextureState.getNumberOfTotalUnits(); ++i) {
            if (state.getTexture(i) == null || state.getTexture(i).getImageLocation() == null) continue;
            HashMap<String, Object> atts = new HashMap<String, Object>();
            atts.clear();
            Texture toTest = state.getTexture(i);
            String s = toTest.getImageLocation();
            if (this.sharedObjects.containsKey(state)) {
                atts.put("sharedident", this.sharedObjects.get(state));
            }
            if ("file:/".equals(s.substring(0, 6))) {
                atts.put("file", JmeBinaryWriter.replaceSpecialsForFile(new StringBuffer(s.substring(6))).toString());
            } else {
                atts.put("URL", new URL(s));
            }
            atts.put("wrap", new Integer(toTest.getWrap()));
            atts.put("texnum", new Integer(i));
            if (toTest.getScale() != null) {
                atts.put("scale", toTest.getScale());
            }
            this.writeTag("texture", atts);
            this.writeEndTag("texture");
        }
        this.writeEndTag("texturestate");
    }

    private static StringBuffer replaceSpecialsForFile(StringBuffer s) {
        int i = s.indexOf("%20");
        if (i == -1) {
            return s;
        }
        return JmeBinaryWriter.replaceSpecialsForFile(s.replace(i, i + 3, " "));
    }

    private void writeMaterialState(MaterialState state) throws IOException {
        if (state == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(state)) {
            atts.put("sharedident", this.sharedObjects.get(state));
        }
        atts.put("emissive", state.getEmissive());
        atts.put("ambient", state.getAmbient());
        atts.put("diffuse", state.getDiffuse());
        atts.put("specular", state.getSpecular());
        atts.put("shiny", new Float(state.getShininess()));
        atts.put("color", new Integer(state.getColorMaterial()));
        atts.put("face", new Integer(state.getMaterialFace()));
        this.writeTag("materialstate", atts);
        this.writeEndTag("materialstate");
    }

    private void writeAlphaState(AlphaState state) throws IOException {
        if (state == null) {
            return;
        }
        HashMap<String, Object> atts = new HashMap<String, Object>();
        atts.clear();
        if (this.sharedObjects.containsKey(state)) {
            atts.put("sharedident", this.sharedObjects.get(state));
        }
        atts.put("srcfunc", new Integer(state.getSrcFunction()));
        atts.put("dstfunc", new Integer(state.getDstFunction()));
        atts.put("testfunc", new Integer(state.getTestFunction()));
        atts.put("reference", new Float(state.getReference()));
        atts.put("blend", new Boolean(state.isBlendEnabled()));
        atts.put("test", new Boolean(state.isTestEnabled()));
        atts.put("enabled", new Boolean(state.isEnabled()));
        this.writeTag("alphastate", atts);
        this.writeEndTag("alphastate");
    }

    private void writeEndTag(String name) throws IOException {
        this.myOut.writeByte(1);
        this.myOut.writeUTF(name);
    }

    private void writeTag(String name, HashMap atts) throws IOException {
        this.myOut.writeByte(0);
        this.myOut.writeUTF(name);
        if (atts == null) {
            this.myOut.writeByte(0);
            return;
        }
        this.myOut.writeByte(atts.size());
        Iterator i = atts.keySet().iterator();
        while (i.hasNext()) {
            String attName = (String)i.next();
            Object attrib = atts.get(attName);
            this.myOut.writeUTF(attName);
            if (attrib == null) {
                throw new NullPointerException();
            }
            if (attrib instanceof Vector3f[]) {
                this.writeVec3fArray((Vector3f[])attrib);
            } else if (attrib instanceof Vector2f[]) {
                this.writeVec2fArray((Vector2f[])attrib);
            } else if (attrib instanceof ColorRGBA[]) {
                this.writeColorArray((ColorRGBA[])attrib);
            } else if (attrib instanceof String) {
                this.writeString((String)attrib);
            } else if (attrib instanceof int[]) {
                this.writeIntArray((int[])attrib);
            } else if (attrib instanceof Vector3f) {
                this.writeVec3f((Vector3f)attrib);
            } else if (attrib instanceof Vector2f) {
                this.writeVec2f((Vector2f)attrib);
            } else if (attrib instanceof Quaternion) {
                this.writeQuat((Quaternion)attrib);
            } else if (attrib instanceof Float) {
                this.writeFloat((Float)attrib);
            } else if (attrib instanceof ColorRGBA) {
                this.writeColor((ColorRGBA)attrib);
            } else if (attrib instanceof URL) {
                this.writeURL((URL)attrib);
            } else if (attrib instanceof Integer) {
                this.writeInt((Integer)attrib);
            } else if (attrib instanceof Boolean) {
                this.writeBoolean((Boolean)attrib);
            } else if (attrib instanceof Quaternion[]) {
                this.writeQuatArray((Quaternion[])attrib);
            } else if (attrib instanceof byte[]) {
                this.writeByteArray((byte[])attrib);
            } else if (attrib instanceof short[]) {
                this.writeShortArray((short[])attrib);
            } else if (attrib instanceof Matrix3f) {
                this.writeMatrix3((Matrix3f)attrib);
            } else {
                throw new RuntimeException("unknown class type for " + attrib + " of " + attrib.getClass() + " in attr " + attName);
            }
            i.remove();
        }
    }

    private void writeMatrix3(Matrix3f m) throws IOException {
        this.myOut.writeByte(16);
        this.myOut.writeFloat(m.m00);
        this.myOut.writeFloat(m.m01);
        this.myOut.writeFloat(m.m02);
        this.myOut.writeFloat(m.m10);
        this.myOut.writeFloat(m.m11);
        this.myOut.writeFloat(m.m12);
        this.myOut.writeFloat(m.m20);
        this.myOut.writeFloat(m.m21);
        this.myOut.writeFloat(m.m22);
    }

    private void writeShortArray(short[] array) throws IOException {
        this.myOut.writeByte(14);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.myOut.writeShort(array[i]);
        }
    }

    private void writeByteArray(byte[] array) throws IOException {
        this.myOut.writeByte(13);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.myOut.writeByte(array[i]);
        }
    }

    private void writeQuatArray(Quaternion[] array) throws IOException {
        this.myOut.writeByte(12);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.myOut.writeFloat(array[i].x);
            this.myOut.writeFloat(array[i].y);
            this.myOut.writeFloat(array[i].z);
            this.myOut.writeFloat(array[i].w);
        }
    }

    private void writeBoolean(Boolean aBoolean) throws IOException {
        this.myOut.writeByte(11);
        this.myOut.writeBoolean(aBoolean);
    }

    private void writeInt(Integer i) throws IOException {
        this.myOut.writeByte(10);
        this.myOut.writeInt(i);
    }

    private void writeURL(URL url) throws IOException {
        this.myOut.writeByte(9);
        this.myOut.writeUTF(url.toString());
    }

    private void writeColor(ColorRGBA c) throws IOException {
        this.myOut.writeByte(8);
        this.myOut.writeFloat(c.r);
        this.myOut.writeFloat(c.g);
        this.myOut.writeFloat(c.b);
        this.myOut.writeFloat(c.a);
    }

    private void writeFloat(Float f) throws IOException {
        this.myOut.writeByte(7);
        this.myOut.writeFloat(f.floatValue());
    }

    private void writeQuat(Quaternion q) throws IOException {
        this.myOut.writeByte(6);
        this.myOut.writeFloat(q.x);
        this.myOut.writeFloat(q.y);
        this.myOut.writeFloat(q.z);
        this.myOut.writeFloat(q.w);
    }

    private void writeVec3f(Vector3f v) throws IOException {
        this.myOut.writeByte(5);
        this.myOut.writeFloat(v.x);
        this.myOut.writeFloat(v.y);
        this.myOut.writeFloat(v.z);
    }

    private void writeVec2f(Vector2f v) throws IOException {
        this.myOut.writeByte(15);
        this.myOut.writeFloat(v.x);
        this.myOut.writeFloat(v.y);
    }

    private void writeIntArray(int[] array) throws IOException {
        this.myOut.writeByte(4);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.myOut.writeInt(array[i]);
        }
    }

    private void writeString(String s) throws IOException {
        this.myOut.writeByte(3);
        this.myOut.writeUTF(s);
    }

    private void writeColorArray(ColorRGBA[] array) throws IOException {
        this.myOut.writeByte(2);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.myOut.writeFloat(array[i].r);
            this.myOut.writeFloat(array[i].g);
            this.myOut.writeFloat(array[i].b);
            this.myOut.writeFloat(array[i].a);
        }
    }

    private void writeVec2fArray(Vector2f[] array) throws IOException {
        this.myOut.writeByte(1);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                continue;
            }
            this.myOut.writeFloat(array[i].x);
            this.myOut.writeFloat(array[i].y);
        }
    }

    private void writeVec3fArray(Vector3f[] array) throws IOException {
        this.myOut.writeByte(0);
        this.myOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                this.myOut.writeFloat(Float.NaN);
                continue;
            }
            this.myOut.writeFloat(array[i].x);
            this.myOut.writeFloat(array[i].y);
            this.myOut.writeFloat(array[i].z);
        }
    }

    private void putSpatialAtts(Spatial spatial, HashMap<String, Object> atts) {
        atts.put("name", spatial.getName());
        if (!spatial.getLocalScale().equals((Object)DEFAULT_SCALE)) {
            atts.put("scale", spatial.getLocalScale());
        }
        if (!spatial.getLocalRotation().equals((Object)DEFAULT_ROTATION)) {
            atts.put("rotation", spatial.getLocalRotation());
        }
        if (!spatial.getLocalTranslation().equals((Object)DEFAULT_TRANSLATION)) {
            atts.put("translation", spatial.getLocalTranslation());
        }
    }

    private void writeClosing() throws IOException {
        this.writeEndTag("scene");
        this.myOut.writeByte(2);
    }

    private void writeHeader() throws IOException {
        this.myOut.writeLong(1234567L);
        this.writeTag("scene", null);
    }

    public void setProperty(String key, Object property) {
        this.properties.put(key, property);
    }

    public void clearProperty(String key) {
        this.properties.remove(key);
    }
}

