/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.terrain.util;

import com.jme.system.JmeException;
import com.jmex.terrain.util.AbstractHeightMap;
import java.util.Random;
import java.util.logging.Logger;

public class FluidSimHeightMap
extends AbstractHeightMap {
    private static final Logger logger = Logger.getLogger(FluidSimHeightMap.class.getName());
    private float waveSpeed = 100.0f;
    private float timeStep = 0.033f;
    private float nodeDistance = 10.0f;
    private float viscosity = 100.0f;
    private int iterations;
    private int minInitialHeight = -500;
    private int maxInitialHeight = 500;
    private long seed;
    float coefA;
    float coefB;
    float coefC;

    public FluidSimHeightMap(int n, int n2, int n3, int n4, float f, float f2, float f3, float f4, long l) {
        if (n <= 0 || n2 <= 0 || n3 >= n4) {
            throw new JmeException("Either size of the terrain is not greater that zero, or number of iterations is not greater that zero, or minimum height greater or equal as the maximum, or maximum height smaller or equal as the minimum.");
        }
        this.size = n;
        this.seed = l;
        this.iterations = n2;
        this.minInitialHeight = n3;
        this.maxInitialHeight = n4;
        this.viscosity = f;
        this.waveSpeed = f2;
        this.timeStep = f3;
        this.nodeDistance = f4;
        this.load();
    }

    public FluidSimHeightMap(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new JmeException("Either size of the terrain is not greater that zero, or number of iterations is not greater that zero");
        }
        this.size = n;
        this.iterations = n2;
        this.load();
    }

    public boolean load() {
        int n;
        int n2;
        int n3;
        int n4;
        if (null != this.heightData) {
            this.unloadHeightMap();
        }
        this.heightData = new int[this.size * this.size];
        float[][] fArray = new float[2][this.size * this.size];
        Random random = new Random(this.seed);
        this.coefA = (4.0f - 8.0f * this.waveSpeed * this.waveSpeed * this.timeStep * this.timeStep / (this.nodeDistance * this.nodeDistance)) / (this.viscosity * this.timeStep + 2.0f);
        this.coefB = (this.viscosity * this.timeStep - 2.0f) / (this.viscosity * this.timeStep + 2.0f);
        this.coefC = 2.0f * this.waveSpeed * this.waveSpeed * this.timeStep * this.timeStep / (this.nodeDistance * this.nodeDistance) / (this.viscosity * this.timeStep + 2.0f);
        for (n4 = 0; n4 < this.size; ++n4) {
            for (n3 = 0; n3 < this.size; ++n3) {
                if (n4 == 0 | n3 == 0 || n4 == this.size - 1 || n3 == this.size - 1) {
                    fArray[1][n3 + n4 * this.size] = 0.0f;
                    fArray[0][n3 + n4 * this.size] = 0.0f;
                    continue;
                }
                float f = this.randomRange(random, this.minInitialHeight, this.maxInitialHeight);
                fArray[1][n3 + n4 * this.size] = f;
                fArray[0][n3 + n4 * this.size] = f;
            }
        }
        n4 = 0;
        for (n2 = 0; n2 < this.iterations; ++n2) {
            float[] fArray2 = fArray[1 - n4];
            float[] fArray3 = fArray[n4];
            for (n = 1; n < this.size - 1; ++n) {
                for (int i = 1; i < this.size - 1; ++i) {
                    n3 = i + n * this.size;
                    fArray2[n3] = this.coefA * fArray3[n3] + this.coefB * fArray2[n3] + this.coefC * (fArray3[n3 + 1] + fArray3[n3 - 1] + fArray3[n3 + this.size] + fArray3[n3 - this.size]);
                }
            }
            n4 = 1 - n4;
        }
        this.normalize(fArray[n4]);
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.heightData[n + n2 * this.size] = (int)(fArray[n4][n + n2 * this.size] * 255.0f);
            }
        }
        logger.info("Created Heightmap using fluid simulation");
        return true;
    }

    protected void normalize(float[] fArray) {
        int n;
        int n2;
        float f = fArray[0];
        float f2 = fArray[0];
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                if (fArray[n + n2 * this.size] > f2) {
                    f2 = fArray[n + n2 * this.size];
                    continue;
                }
                if (!(fArray[n + n2 * this.size] < f)) continue;
                f = fArray[n + n2 * this.size];
            }
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                fArray[n + n2 * this.size] = (fArray[n + n2 * this.size] - f) / (f2 - f);
            }
        }
    }

    private float randomRange(Random random, float f, float f2) {
        return (float)random.nextInt() * (f2 - f) / 2.1474836E9f + f;
    }

    public void setIterations(int n) {
        if (n <= 0) {
            throw new JmeException("Number of iterations is not greater than zero");
        }
        this.iterations = n;
    }

    public void setMaxInitialHeight(int n) {
        this.maxInitialHeight = n;
    }

    public void setMinInitialHeight(int n) {
        this.minInitialHeight = n;
    }

    public void setNodeDistance(float f) {
        this.nodeDistance = f;
    }

    public void setTimeStep(float f) {
        this.timeStep = f;
    }

    public void setViscosity(float f) {
        this.viscosity = f;
    }

    public void setWaveSpeed(float f) {
        this.waveSpeed = f;
    }
}

