/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.VideoData;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.JpegKeeper;
import jp.sourceforge.akjrcp.text_douga.video.VideoImageInput;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VideoUtils {
    public static Log log = LogFactory.getLog(VideoUtils.class);

    public static int copyVideo(String ffmpegPath, String inputPath, double start, double duration, File exportDir, int startIndex, double fps, int width, int height, int maxframe) throws IOException {
        byte[] bytes;
        int writed = 0;
        VideoImageInput videoInput = new VideoImageInput(ffmpegPath, inputPath, start, duration);
        videoInput.setFps(fps);
        videoInput.setWidth(width);
        videoInput.setHeight(height);
        JpegKeeper jpegKeeper = videoInput.getJpegKeeper();
        videoInput.startInput();
        while ((bytes = jpegKeeper.nextImage()) != null) {
            if (DougaSystem.cancelling) {
                log.info((Object)"dougasystem cancelled");
                break;
            }
            File jpegFile = new File(exportDir, VideoUtils.toFileName("", startIndex + writed, 5, "jpg"));
            FileUtils.writeByteArrayToFile((File)jpegFile, (byte[])bytes);
            log.trace((Object)("write:" + ++writed));
            if (writed != maxframe) continue;
            videoInput.setCanceling(true);
            break;
        }
        return writed;
    }

    public static int copyVideo(VideoData videoData, VideoWriter writer, String ffmpegPath, String inputPath, double start, double duration, double fps, int width, int height) throws IOException {
        int writed = 0;
        VideoImageInput videoInput = new VideoImageInput(ffmpegPath, inputPath, start, duration);
        videoInput.setFps(fps);
        videoInput.setWidth(width);
        videoInput.setHeight(height);
        JpegKeeper jpegKeeper = videoInput.getJpegKeeper();
        videoInput.startInput();
        byte[] bytes = null;
        BufferedImage img = null;
        boolean finished = false;
        while ((bytes = jpegKeeper.nextImage()) != null) {
            if (DougaSystem.cancelling) {
                log.info((Object)"dougasystem cancelled");
                break;
            }
            if (img != null) {
                finished = writer.writeFrame(videoData, img);
                ++writed;
                if (finished) {
                    videoInput.setCanceling(true);
                    break;
                }
            }
            img = ImageIO.read(new ByteArrayInputStream(bytes));
            log.trace((Object)("write:" + writed));
        }
        if (!finished && img != null) {
            writer.writeFrame(videoData, img);
            ++writed;
        }
        return writed;
    }

    public static int copyImage(BufferedImage image, File exportDir, int startIndex, int frames) throws IOException {
        int writed = 0;
        int i = 0;
        while (i < frames) {
            if (DougaSystem.cancelling) {
                log.info((Object)"dougasystem cancelled");
                break;
            }
            File jpegFile = new File(exportDir, VideoUtils.toFileName("", startIndex + writed, 5, "jpg"));
            ++writed;
            ImageUtils.writeJpegWithQuality((BufferedImage)image, (File)jpegFile, (float)1.0f);
            ++i;
        }
        return writed;
    }

    public static int copyImage(BufferedImage image, VideoData videoData, VideoWriter writer, int frames) throws IOException {
        int writed = 0;
        int i = 0;
        while (i < frames) {
            if (DougaSystem.cancelling) {
                log.info((Object)"dougasystem cancelled");
                break;
            }
            writer.writeFrame(videoData, image);
            if (++writed % 100 == 0) {
                log.info((Object)("copyImage writed:" + writed));
            }
            ++i;
        }
        return writed;
    }

    public static int loopVideo(String ffmpegPath, String input, double start, double duration, int looptime, double padtime, int padcolor, boolean cutInLoop, File exportDir, int startIndex, double fps, int width, int height, int maxframe) throws IOException {
        if (looptime == 0) {
            log.warn((Object)"loop is 0");
            return 0;
        }
        if (looptime == -1 && maxframe == 0) {
            log.warn((Object)"it's never stop");
            return 0;
        }
        log.info((Object)("cutInLoop:" + cutInLoop));
        int firstWrite = VideoUtils.copyVideo(ffmpegPath, input, start, duration, exportDir, startIndex, fps, width, height, maxframe);
        if (looptime == 1) {
            return firstWrite;
        }
        log.info((Object)("first write:" + firstWrite));
        int writed = firstWrite;
        if (writed >= maxframe && maxframe > 0) {
            return writed;
        }
        int looped = 1;
        boolean loop = true;
        block0: while (loop) {
            if (loop && padtime > 0.0) {
                int colorframe = (int)(fps * padtime);
                int i = 0;
                while (i < colorframe) {
                    if (DougaSystem.cancelling) {
                        log.info((Object)"dougasystem cancelled");
                        break block0;
                    }
                    String colorPath = String.valueOf(exportDir.getAbsolutePath()) + "\\" + VideoUtils.toFileName("", startIndex + writed, 5, "jpg");
                    VideoUtils.writeColorImage(width, height, colorPath, padcolor);
                    if (++writed == maxframe) break block0;
                    ++i;
                }
                log.info((Object)("pad:" + colorframe + " color" + padcolor));
            }
            int i = 0;
            while (i < firstWrite) {
                String srcPath = String.valueOf(exportDir.getAbsolutePath()) + "\\" + VideoUtils.toFileName("", startIndex + i, 5, "jpg");
                String destPath = String.valueOf(exportDir.getAbsolutePath()) + "\\" + VideoUtils.toFileName("", startIndex + writed, 5, "jpg");
                FileUtils.copyFile((File)new File(srcPath), (File)new File(destPath));
                if (++writed == maxframe) {
                    if (cutInLoop) break block0;
                    loop = false;
                }
                ++i;
            }
            if (++looped == looptime) {
                loop = false;
            }
            log.info((Object)("loop:" + looped + " write" + writed));
        }
        return writed;
    }

    public static int loopVideo(VideoData videoData, VideoWriter writer, String ffmpegPath, String input, double start, double duration, int looptime, double padtime, int padcolor, boolean cutInLoop, double fps, int width, int height) throws IOException {
        if (looptime == 0) {
            log.warn((Object)"loop is 0");
            return 0;
        }
        if (looptime == -1 && writer.getMaxFrame() == 0) {
            log.warn((Object)"it's never stop");
            return 0;
        }
        log.info((Object)("cutInLoop:" + cutInLoop));
        int startIndex = writer.getWrited() + 1;
        int maxframe = Math.max(0, writer.getMaxFrame() - writer.getWrited());
        int firstWrite = VideoUtils.copyVideo(ffmpegPath, input, start, duration, writer.getWorkingDir(), startIndex, fps, width, height, maxframe);
        int i = 0;
        while (i < firstWrite) {
            File frame = writer.getWorkingFrameFile(i + startIndex);
            BufferedImage image = ImageIO.read(frame);
            writer.writeFrame(videoData, image);
            ++i;
        }
        if (looptime == 1) {
            return firstWrite;
        }
        log.info((Object)("first write:" + firstWrite));
        int writed = firstWrite;
        if (writed >= maxframe && maxframe > 0) {
            return writed;
        }
        int looped = 1;
        boolean loop = true;
        block1: while (loop) {
            if (loop && padtime > 0.0) {
                int colorframe = (int)(fps * padtime);
                int i2 = 0;
                while (i2 < colorframe) {
                    if (DougaSystem.cancelling) {
                        log.info((Object)"dougasystem cancelled");
                        break block1;
                    }
                    BufferedImage colorImage = VideoUtils.makeColorImage(width, height, padcolor);
                    writer.writeFrame(videoData, colorImage);
                    if (++writed == maxframe) break block1;
                    ++i2;
                }
                log.info((Object)("pad:" + colorframe + " color" + padcolor));
            }
            int i3 = 0;
            while (i3 < firstWrite) {
                File frame = writer.getWorkingFrameFile(i3 + startIndex);
                BufferedImage image = ImageIO.read(frame);
                writer.writeFrame(videoData, image);
                if (++writed == writer.getMaxFrame()) {
                    if (cutInLoop) break block1;
                    loop = false;
                }
                ++i3;
            }
            if (++looped == looptime) {
                loop = false;
            }
            log.info((Object)("loop:" + looped + " write" + writed));
        }
        return writed;
    }

    public static void writeColorImage(int width, int height, String path, int color) throws IOException {
        ImageIO.write((RenderedImage)VideoUtils.makeColorImage(width, height, color), "jpeg", new File(path));
    }

    public static BufferedImage makeColorImage(int width, int height, int color) {
        BufferedImage bimage = new BufferedImage(width, height, 1);
        Graphics g = bimage.getGraphics();
        g.setColor(new Color(color));
        g.fillRect(0, 0, width, height);
        return bimage;
    }

    public static String toFileName(String header, int index, int digits, String extension) {
        String value = header;
        String c = "" + index;
        while (c.length() < digits) {
            c = "0" + c;
        }
        value = String.valueOf(value) + c;
        value = String.valueOf(value) + "." + extension;
        return value;
    }
}

