/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.video;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeWriter;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.EffectData;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.ItemData;
import jp.sourceforge.akjrcp.text_douga.VideoData;
import jp.sourceforge.akjrcp.text_douga.video.AbstractVideoWriter;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PipedVideoWriter
extends AbstractVideoWriter {
    public static Log log = LogFactory.getLog(PipedVideoWriter.class);
    private JpegPipeWriter jpegPipeWriter;
    private ItemData[] itemDatas;
    private EffectData[] effectDatas;
    private DougaPreference dougaPreference;
    private BufferedImage lastImage;
    private VideoData lastVideoData;
    private BufferedImage bufferedImage;
    private Graphics2D graphics2D;

    public PipedVideoWriter(DougaPreference dougaPreference, JpegPipeWriter jpegPipeWriter, File workingDir) {
        this.dougaPreference = dougaPreference;
        this.jpegPipeWriter = jpegPipeWriter;
        this.setWorkingDir(workingDir);
    }

    public EffectData[] getEffectDatas() {
        return this.effectDatas;
    }

    public void setEffectDatas(EffectData[] effectDatas) {
        this.effectDatas = effectDatas;
    }

    public ItemData[] getItemDatas() {
        return this.itemDatas;
    }

    public void setItemDatas(ItemData[] itemDatas) {
        this.itemDatas = itemDatas;
    }

    public JpegPipeWriter getJpegPipeWriter() {
        return this.jpegPipeWriter;
    }

    public void setJpegPipeWriter(JpegPipeWriter jpegPipeWriter) {
        this.jpegPipeWriter = jpegPipeWriter;
    }

    public BufferedImage getLastImage() {
        return this.lastImage;
    }

    @Override
    public boolean writeFrame(VideoData videoData, BufferedImage image) throws IOException {
        if (this.bufferedImage == null) {
            this.bufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            this.graphics2D = (Graphics2D)this.bufferedImage.getGraphics();
        }
        if (videoData != this.lastVideoData) {
            File outFrame = this.getWorkingFrameFile(this.writed + 1);
            ImageUtils.writeJpegWithQuality((BufferedImage)image, (File)outFrame, (float)1.0f);
            if (this.lastImage != null) {
                ImageUtils.writeJpegWithQuality((BufferedImage)this.lastImage, (File)this.getWorkingFrameFile(this.writed), (float)1.0f);
            }
        }
        this.graphics2D.drawImage(image, null, 0, 0);
        this.effectAndItem(this.bufferedImage, this.writed + 1);
        if (this.jpegPipeWriter == null) {
            log.warn((Object)"jpegPipeWriter null");
            throw new IOException("jpegPipeWriter null");
        }
        this.jpegPipeWriter.writeJpeg(this.bufferedImage);
        ++this.writed;
        this.lastImage = this.bufferedImage;
        this.lastVideoData = videoData;
        return this.writed == this.maxFrame;
    }

    private void effectAndItem(BufferedImage img, int index) {
        int k;
        ImageObject imageObject = new ImageObject(img);
        if (this.itemDatas != null) {
            k = 0;
            while (k < this.itemDatas.length) {
                try {
                    this.itemDatas[k].writeFrame(this.dougaPreference, imageObject, index);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++k;
            }
        }
        if (this.effectDatas != null) {
            k = 0;
            while (k < this.effectDatas.length) {
                this.effectDatas[k].setExportDir(this.getWorkingDir());
                try {
                    this.effectDatas[k].writeFrame(this.dougaPreference, imageObject, index);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++k;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.jpegPipeWriter.close();
    }
}

