/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.Rectangle;
import java.awt.Shape;
import jp.sourceforge.akjrcp.text_douga.item.TextItem;
import org.apache.commons.lang.ArrayUtils;

public class KaraokeItem
extends TextItem {
    private double[] timing;
    public static char[] whitespaces = new char[]{' ', '\t', '\n', '\u3000'};
    private int selectionStrings = 0;
    private double progressed = 0.0;

    public KaraokeItem(String text) {
        super(text);
    }

    @Override
    public String toString() {
        return "KaraokeItem:" + super.toString() + " timing=" + ArrayUtils.toString((Object)this.timing);
    }

    public double[] getTiming() {
        return this.timing;
    }

    public void setTiming(double[] timing) {
        this.timing = timing;
    }

    @Override
    public void beforeWriteFrame(double time) {
        if (this.timing == null) {
            this.initDefaultTiming();
        }
        if (time < this.timing[0]) {
            return;
        }
        double total = 0.0;
        this.progressed = 0.0;
        int i = 0;
        while (i < this.timing.length) {
            if (time >= (total += this.timing[i])) {
                this.selectionStrings = i++;
                continue;
            }
            this.progressed = (time - (total - this.timing[i])) / this.timing[i];
            log.info((Object)("progressed:" + this.progressed + " time=" + time));
            break;
        }
    }

    @Override
    public Shape getSelectionShape(int index) {
        if (this.selectionStrings == 0 && index == 0) {
            if (this.progressed > 0.0 && this.progressed < 1.0) {
                Shape selected2 = this.textLinesLayout.getTextLayouts()[0].getLogicalHighlightShape(0, 1);
                Rectangle rect2 = selected2.getBounds();
                rect2.width = (int)((double)rect2.width * this.progressed);
                return rect2;
            }
            return null;
        }
        int total = 0;
        String[] lines = this.textLinesLayout.getTexts();
        int i = 0;
        while (i <= index) {
            int characters = this.countNotWhiteSpace(lines[i]);
            log.trace((Object)("selectionStrings:" + this.selectionStrings + " v=" + characters));
            if (this.selectionStrings > total && this.selectionStrings <= characters + total) {
                if (i == index) {
                    int selected = this.selectNotWhiteSpace(lines[i], this.selectionStrings - total);
                    log.trace((Object)("selectionStrings:" + this.selectionStrings + " v=" + characters + " select=" + selected));
                    Rectangle rectangle = new Rectangle();
                    Shape selected1 = this.textLinesLayout.getTextLayouts()[i].getLogicalHighlightShape(0, selected);
                    rectangle.add(selected1.getBounds());
                    log.trace((Object)("added1:" + selected1.getBounds()));
                    if (this.progressed > 0.0 && this.progressed < 1.0) {
                        try {
                            Shape selected2 = this.textLinesLayout.getTextLayouts()[i].getLogicalHighlightShape(0, selected + 1);
                            int dw = (int)((double)(selected2.getBounds().width - selected1.getBounds().width) * this.progressed);
                            Rectangle rect2 = selected1.getBounds();
                            rect2.width += dw;
                            rectangle.add(rect2);
                            log.trace((Object)("added2:" + rect2));
                        }
                        catch (Exception e) {
                            log.warn((Object)e.getMessage());
                        }
                    }
                    return rectangle;
                }
            } else if (this.selectionStrings > characters + total && i == index) {
                Shape selected1 = this.textLinesLayout.getTextLayouts()[i].getLogicalHighlightShape(0, lines[i].length());
                return selected1.getBounds();
            }
            total += characters;
            ++i;
        }
        return null;
    }

    private int selectNotWhiteSpace(String text, int selection) {
        if (selection == 0) {
            return 0;
        }
        int c = 0;
        int i = 0;
        while (i < text.length()) {
            boolean w = false;
            int j = 0;
            while (j < whitespaces.length) {
                if (text.charAt(i) == whitespaces[j]) {
                    w = true;
                }
                ++j;
            }
            if (!w) {
                ++c;
            }
            if (c == selection) {
                return i + 1;
            }
            ++i;
        }
        return text.length();
    }

    private int countNotWhiteSpace(String text) {
        int c = 0;
        int i = 0;
        while (i < text.length()) {
            boolean w = false;
            int j = 0;
            while (j < whitespaces.length) {
                if (text.charAt(i) == whitespaces[j]) {
                    w = true;
                }
                ++j;
            }
            if (!w) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    private void initDefaultTiming() {
        int total = 0;
        String[] lines = this.textLinesLayout.getTexts();
        int i = 0;
        while (i < lines.length) {
            total += this.countNotWhiteSpace(lines[i]);
            ++i;
        }
        double v = (this.duration - 0.1) / (double)total;
        this.timing = new double[total + 1];
        this.timing[0] = 0.0;
        int i2 = 1;
        while (i2 < total + 1) {
            this.timing[i2] = v;
            ++i2;
        }
    }
}

