/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.effect;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.EffectData;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class VideoEffect
implements EffectData {
    public static Log log = LogFactory.getLog(VideoEffect.class);
    public static final int NULL_TIME = -9999;
    private int keyFrame = -9999;
    private double beforeTime = 0.2;
    private double afterTime = 0.2;
    private int mode;
    private File exportDir;
    protected double fullEffectTime = 0.0;

    public double getFullEffectTime() {
        return this.fullEffectTime;
    }

    public void setFullEffectTime(double fullPaintTime) {
        this.fullEffectTime = fullPaintTime;
    }

    public String toString() {
        String out = "keyFrame=" + this.keyFrame + " beforeTime=" + this.beforeTime + " afterTime=" + this.afterTime + " mode=" + this.mode + " fullEffect=" + this.fullEffectTime + " exportDir=" + this.exportDir;
        return out;
    }

    public double getAfterTime() {
        return this.afterTime;
    }

    public void setAfterTime(double afterTime) {
        this.afterTime = afterTime;
    }

    public double getBeforeTime() {
        return this.beforeTime;
    }

    public void setBeforeTime(double beforeTime) {
        this.beforeTime = beforeTime;
    }

    public int getKeyFrame() {
        return this.keyFrame;
    }

    @Override
    public void setKeyFrame(int keyFrame) {
        this.keyFrame = keyFrame;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        if (this.mode == -1) {
            this.effectAll(preference, baseImage.getImage(), frame);
            return true;
        }
        double keyTime = new BigDecimal("" + this.keyFrame).divide(new BigDecimal("" + preference.getFps())).doubleValue();
        double frameTime = new BigDecimal("" + frame).divide(new BigDecimal("" + preference.getFps())).doubleValue();
        if (frame == this.keyFrame) {
            log.info((Object)("effect-keyframe: frame=" + frame));
            this.effectKeyFrame(preference, baseImage.getImage(), frame, 0.0);
            return true;
        }
        if (frameTime < keyTime && frameTime > keyTime - this.beforeTime) {
            double time = frameTime - keyTime;
            log.info((Object)("before-effect:" + frameTime + "," + time + " frame=" + frame));
            this.effectBefore(preference, baseImage.getImage(), frame, time);
            return true;
        }
        if (frameTime > keyTime && frameTime < keyTime + this.afterTime) {
            double time = frameTime - keyTime;
            log.info((Object)("after-effect:" + frameTime + "," + time + " frame=" + frame));
            this.effectAfter(preference, baseImage.getImage(), frame, time);
            return true;
        }
        return false;
    }

    public abstract void effectAll(DougaPreference var1, BufferedImage var2, int var3) throws IOException;

    public abstract void effectBefore(DougaPreference var1, BufferedImage var2, int var3, double var4) throws IOException;

    public abstract void effectAfter(DougaPreference var1, BufferedImage var2, int var3, double var4) throws IOException;

    public abstract void effectKeyFrame(DougaPreference var1, BufferedImage var2, int var3, double var4) throws IOException;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public File getExportDir() {
        return this.exportDir;
    }

    @Override
    public void setExportDir(File exportDir) {
        this.exportDir = exportDir;
    }
}

