/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.audio;

import java.io.IOException;
import java.io.OutputStream;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.audio.AudioUtils;

public class ZeroAudioData
implements AudioData {
    private boolean fitLogicalLength;
    private double logicalLength;
    private double duration;

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public boolean isFitLogicalLength() {
        return this.fitLogicalLength;
    }

    public double getLogicalLength() {
        return this.logicalLength;
    }

    @Override
    public void setSynch(boolean fitLogicalLength) {
        this.fitLogicalLength = fitLogicalLength;
    }

    @Override
    public void setSynchLength(double logicalLength) {
        this.logicalLength = logicalLength;
    }

    @Override
    public long writeData(DougaPreference preference, OutputStream outputStream, long maxbytes) throws IOException {
        double d = this.duration;
        if (this.fitLogicalLength) {
            d = this.logicalLength;
        }
        if (d > 0.0) {
            return AudioUtils.writeZero(outputStream, d, preference.getAudioRate(), preference.getAudioChannel());
        }
        return 0L;
    }

    @Override
    public double getTotalTime() {
        return this.duration;
    }
}

