/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.EffectData;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.ItemData;
import jp.sourceforge.akjrcp.text_douga.Messages;
import jp.sourceforge.akjrcp.text_douga.VideoData;
import jp.sourceforge.akjrcp.text_douga.VideoOutInfo;
import jp.sourceforge.akjrcp.text_douga.VideoWriter;
import jp.sourceforge.akjrcp.text_douga.video.VideoUtils;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VideoSystem {
    public static Log log = LogFactory.getLog(VideoSystem.class);
    private List<VideoData> videoDatas = new ArrayList<VideoData>();
    private List<ItemData> itemDatas = new ArrayList<ItemData>();
    private List<EffectData> effectDatas = new ArrayList<EffectData>();
    private double maxTime;
    private DougaPreference videoPreference = new DougaPreference();
    private ItemSorter itemSorter = new ItemSorter();
    private boolean cancelling;

    public int countItems() {
        return this.itemDatas.size();
    }

    public VideoOutInfo[] writeDatas(File dir) throws IOException {
        ArrayList<VideoOutInfo> videoOutInfos = new ArrayList<VideoOutInfo>();
        int maxframe = (int)(this.maxTime * this.videoPreference.getFps());
        VideoData[] datas = this.getVideoDatas();
        int writed = 0;
        int i = 0;
        while (i < datas.length) {
            int wf = 0;
            wf = datas[i].writeData(dir, this.videoPreference, writed + 1, maxframe);
            VideoOutInfo info = new VideoOutInfo(datas[i], wf);
            videoOutInfos.add(info);
            if (maxframe != 0 && (writed += wf) >= maxframe) {
                log.info((Object)"over maxframe:");
                break;
            }
            DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("log.finish_video_sequence")) + ":" + (i + 1) + " of " + datas.length);
            if (this.cancelling) {
                log.info((Object)"cancelled");
                return null;
            }
            ++i;
        }
        return videoOutInfos.toArray(new VideoOutInfo[videoOutInfos.size()]);
    }

    public VideoOutInfo[] writeDatas(VideoWriter writer) throws IOException {
        ArrayList<VideoOutInfo> videoOutInfos = new ArrayList<VideoOutInfo>();
        int maxframe = (int)(this.maxTime * this.videoPreference.getFps());
        writer.setMaxFrame(maxframe);
        VideoData[] datas = this.getVideoDatas();
        int writed = 0;
        int i = 0;
        while (i < datas.length) {
            int wf = 0;
            log.info((Object)("start write VideoData " + i + " " + datas[i]));
            wf = datas[i].writeData(writer, this.videoPreference);
            VideoOutInfo info = new VideoOutInfo(datas[i], wf);
            videoOutInfos.add(info);
            if (maxframe != 0 && (writed += wf) >= maxframe) {
                log.info((Object)"over maxframe:");
                break;
            }
            DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("log.finish_video_sequence")) + ":" + (i + 1) + " of " + datas.length);
            if (this.cancelling) {
                log.info((Object)"cancelled");
                return null;
            }
            ++i;
        }
        writer.close();
        return videoOutInfos.toArray(new VideoOutInfo[videoOutInfos.size()]);
    }

    public void writeItemAndEffect(File dir, VideoOutInfo[] outInfos) throws IOException {
        EffectData[] ef = this.effectDatas.toArray(new EffectData[this.effectDatas.size()]);
        int k = 0;
        while (k < ef.length) {
            ef[k].setExportDir(dir);
            log.trace((Object)ef[k]);
            ++k;
        }
        int index = 1;
        ItemData[] items = this.getSortedItemDatas();
        int i = 0;
        while (i < outInfos.length) {
            int maxframe = outInfos[i].getFrames();
            int j = 0;
            while (j < maxframe) {
                String imagePath = VideoSystem.getFrameFilePath(dir, index);
                ImageObject imageObject = null;
                if (new File(imagePath).exists()) {
                    boolean imageModified = false;
                    try {
                        imageObject = new ImageObject(imagePath);
                        int k2 = 0;
                        while (k2 < items.length) {
                            boolean writed = items[k2].writeFrame(this.videoPreference, imageObject, index);
                            if (writed) {
                                imageModified = true;
                            }
                            ++k2;
                        }
                        EffectData[] effects = this.effectDatas.toArray(new EffectData[this.effectDatas.size()]);
                        int k3 = 0;
                        while (k3 < effects.length) {
                            boolean writed = effects[k3].writeFrame(this.videoPreference, imageObject, index);
                            if (writed) {
                                imageModified = true;
                            }
                            ++k3;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (imageModified) {
                        ImageUtils.writeJpegWithQuality((BufferedImage)imageObject.getImage(), (File)new File(imagePath), (float)1.0f);
                    }
                } else {
                    log.warn((Object)("img not found:" + imageObject.getImage()));
                }
                ++index;
                if (this.cancelling) {
                    log.info((Object)"cancelled");
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public static String getFrameFilePath(File exportDir, int index) {
        String path = String.valueOf(exportDir.getAbsolutePath()) + "\\" + VideoUtils.toFileName("", index, 5, "jpg");
        return path;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(double maxTime) {
        this.maxTime = maxTime;
    }

    public void setEffectDatas(List<EffectData> effectDatas) {
        this.effectDatas = effectDatas;
    }

    public void addVideoData(VideoData videoData) {
        this.videoDatas.add(videoData);
    }

    public VideoData[] getVideoDatas() {
        return this.videoDatas.toArray(new VideoData[this.videoDatas.size()]);
    }

    public void addItemData(ItemData itemData) {
        this.itemDatas.add(itemData);
    }

    public ItemData[] getSortedItemDatas() {
        ItemData[] data = this.itemDatas.toArray(new ItemData[this.itemDatas.size()]);
        Arrays.sort(data, this.itemSorter);
        return data;
    }

    public void addEffectData(EffectData effectData) {
        this.effectDatas.add(effectData);
    }

    public EffectData[] getEffectDatas() {
        return this.effectDatas.toArray(new EffectData[this.effectDatas.size()]);
    }

    public DougaPreference getDougaPreference() {
        return this.videoPreference;
    }

    public void setDougaPreference(DougaPreference videoPreference) {
        this.videoPreference = videoPreference;
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public void setCancelling(boolean cancelling) {
        this.cancelling = cancelling;
    }

    public class ItemSorter
    implements Comparator<ItemData> {
        @Override
        public int compare(ItemData o1, ItemData o2) {
            return o1.getZ() - o2.getZ();
        }
    }
}

