/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.text_douga.AudioData;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.DougaSystem;
import jp.sourceforge.akjrcp.text_douga.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AudioSystem {
    public static final int FOREEVER = -1;
    public static Log log = LogFactory.getLog(AudioSystem.class);
    private List<AudioData> audioDatas = new ArrayList<AudioData>();
    private double maxTime;
    private String ffmpegPath;
    private int rate = 48000;
    private int channel = 2;
    private DougaPreference dougaPreference = new DougaPreference();

    public void addAudioData(AudioData audioData) {
        this.audioDatas.add(audioData);
    }

    public AudioData[] getAudioDatas() {
        return this.audioDatas.toArray(new AudioData[this.audioDatas.size()]);
    }

    public void writeDatas(OutputStream outputStream) throws IOException {
        long maxBytes = (long)((double)(this.rate * this.channel * 2) * this.maxTime);
        AudioData[] audios = this.getAudioDatas();
        long remain = maxBytes;
        int i = 0;
        while (i < audios.length) {
            long writed = audios[i].writeData(this.dougaPreference, outputStream, remain);
            if (writed > 0L) {
                remain -= writed;
            }
            log.info((Object)("audiowrite:writed=" + writed + " remain=" + remain + " maxbyte=" + maxBytes));
            DougaSystem.dougaLogger.info(String.valueOf(Messages.getString("log.finish_audio_sequence")) + ":" + (i + 1) + " of " + audios.length);
            ++i;
        }
        outputStream.flush();
        outputStream.close();
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(double maxTime) {
        this.maxTime = maxTime;
    }

    public DougaPreference getDougaPreference() {
        return this.dougaPreference;
    }

    public void setDougaPreference(DougaPreference dougaPreference) {
        this.dougaPreference = dougaPreference;
    }
}

